/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="content")
public class HandleViewResources {
    private static final float HANDLE_HORIZONTAL_PADDING_RATIO = 0.25f;
    private static final int[] LEFT_HANDLE_ATTRS = new int[]{16843461};
    private static final int[] CENTER_HANDLE_ATTRS = new int[]{16843463};
    private static final int[] RIGHT_HANDLE_ATTRS = new int[]{16843462};

    public static Drawable getLeftHandleDrawable(Context context) {
        return HandleViewResources.getHandleDrawable(context, LEFT_HANDLE_ATTRS);
    }

    public static Drawable getCenterHandleDrawable(Context context) {
        return HandleViewResources.getHandleDrawable(context, CENTER_HANDLE_ATTRS);
    }

    public static Drawable getRightHandleDrawable(Context context) {
        return HandleViewResources.getHandleDrawable(context, RIGHT_HANDLE_ATTRS);
    }

    private static Drawable getHandleDrawable(Context context, int[] attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs);
        Drawable drawable2 = a.getDrawable(0);
        if (drawable2 == null) {
            try {
                drawable2 = ApiCompatibilityUtils.getDrawable(context.getResources(), a.getResourceId(0, 0));
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
        }
        a.recycle();
        return drawable2;
    }

    private static Bitmap getHandleBitmap(Context context, int[] attrs) {
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        Drawable drawable2 = HandleViewResources.getHandleDrawable(context, attrs);
        assert (drawable2 != null);
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        Bitmap canvasBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        Canvas canvas = new Canvas(canvasBitmap);
        drawable2.setBounds(0, 0, width, height);
        drawable2.setColorFilter(Color.rgb((int)66, (int)133, (int)243), PorterDuff.Mode.SRC_IN);
        drawable2.draw(canvas);
        return canvasBitmap;
    }

    @CalledByNative
    public static float getHandleHorizontalPaddingRatio() {
        return 0.25f;
    }

    @CalledByNative
    private static Bitmap getLeftHandleBitmap(Context context) {
        return HandleViewResources.getHandleBitmap(context, LEFT_HANDLE_ATTRS);
    }

    @CalledByNative
    private static Bitmap getCenterHandleBitmap(Context context) {
        return HandleViewResources.getHandleBitmap(context, CENTER_HANDLE_ATTRS);
    }

    @CalledByNative
    private static Bitmap getRightHandleBitmap(Context context) {
        return HandleViewResources.getHandleBitmap(context, RIGHT_HANDLE_ATTRS);
    }
}

