/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.util.Printer;
import android.util.StringBuilderPrinter;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.EditorInfo;
import java.util.Locale;
import org.chromium.base.ThreadUtils;

public class ImeUtils {
    public static void computeEditorInfo(int inputType, int inputFlags, int initialSelStart, int initialSelEnd, EditorInfo outAttrs) {
        outAttrs.imeOptions = 0x12000000;
        outAttrs.inputType = 161;
        if ((inputFlags & 2) != 0) {
            outAttrs.inputType |= 0x80000;
        }
        if (inputType == 1) {
            outAttrs.imeOptions |= 2;
            if ((inputFlags & 8) == 0) {
                outAttrs.inputType |= 0x8000;
            }
        } else if (inputType == 14 || inputType == 15) {
            outAttrs.inputType |= 0x20000;
            if ((inputFlags & 8) == 0) {
                outAttrs.inputType |= 0x8000;
            }
            outAttrs.imeOptions |= 1;
        } else if (inputType == 2) {
            outAttrs.inputType = 225;
            outAttrs.imeOptions |= 2;
        } else if (inputType == 3) {
            outAttrs.imeOptions |= 3;
        } else if (inputType == 7) {
            outAttrs.inputType = 17;
            outAttrs.imeOptions |= 2;
        } else if (inputType == 4) {
            outAttrs.inputType = 209;
            outAttrs.imeOptions |= 2;
        } else if (inputType == 6) {
            outAttrs.inputType = 3;
            outAttrs.imeOptions |= 5;
        } else if (inputType == 5) {
            outAttrs.inputType = 8194;
            outAttrs.imeOptions |= 5;
        }
        if ((inputFlags & 0x80) != 0) {
            outAttrs.inputType |= 0x1000;
        } else if ((inputFlags & 0x100) != 0) {
            outAttrs.inputType |= 0x2000;
        } else if ((inputFlags & 0x200) != 0) {
            outAttrs.inputType |= 0x4000;
        }
        if (inputType == 15) {
            outAttrs.inputType |= 0x4000;
        }
        outAttrs.initialSelStart = initialSelStart;
        outAttrs.initialSelEnd = initialSelEnd;
    }

    static String getEditorInfoDebugString(EditorInfo editorInfo) {
        StringBuilder builder = new StringBuilder();
        StringBuilderPrinter printer = new StringBuilderPrinter(builder);
        editorInfo.dump((Printer)printer, "");
        return builder.toString();
    }

    static String getEditableDebugString(Editable editable) {
        return String.format(Locale.US, "Editable {[%s] SEL[%d %d] COM[%d %d]}", editable.toString(), Selection.getSelectionStart((CharSequence)editable), Selection.getSelectionEnd((CharSequence)editable), BaseInputConnection.getComposingSpanStart((Spannable)editable), BaseInputConnection.getComposingSpanEnd((Spannable)editable));
    }

    static String getCorrectionInfoDebugString(CorrectionInfo correctionInfo) {
        return correctionInfo.toString();
    }

    static void checkCondition(boolean condition) {
        if (!condition) {
            throw new AssertionError();
        }
    }

    static void checkCondition(String msg, boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)msg);
        }
    }

    static void checkOnUiThread() {
        ImeUtils.checkCondition("Should be on UI thread.", ThreadUtils.runningOnUiThread());
    }
}

