/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.battery;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.BatteryManager;
import android.os.Build;
import android.util.Log;
import javax.annotation.Nullable;
import org.chromium.base.VisibleForTesting;
import org.chromium.mojom.device.BatteryStatus;

class BatteryStatusManager {
    private static final String TAG = "BatteryStatusManager";
    private final Context mAppContext;
    private final BatteryStatusCallback mCallback;
    private final IntentFilter mFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            BatteryStatusManager.this.onReceive(intent);
        }
    };
    private final boolean mIgnoreBatteryPresentState;
    private AndroidBatteryManagerWrapper mAndroidBatteryManager;
    private boolean mEnabled = false;

    private BatteryStatusManager(Context context, BatteryStatusCallback callback, boolean ignoreBatteryPresentState, @Nullable AndroidBatteryManagerWrapper batteryManager) {
        this.mAppContext = context.getApplicationContext();
        this.mCallback = callback;
        this.mIgnoreBatteryPresentState = ignoreBatteryPresentState;
        this.mAndroidBatteryManager = batteryManager;
    }

    BatteryStatusManager(Context context, BatteryStatusCallback callback) {
        this(context, callback, Build.MODEL.equals("Galaxy Nexus"), Build.VERSION.SDK_INT >= 21 ? new AndroidBatteryManagerWrapper((BatteryManager)context.getSystemService("batterymanager")) : null);
    }

    static BatteryStatusManager createBatteryStatusManagerForTesting(Context context, BatteryStatusCallback callback, @Nullable AndroidBatteryManagerWrapper batteryManager) {
        return new BatteryStatusManager(context, callback, false, batteryManager);
    }

    boolean start() {
        if (!this.mEnabled && this.mAppContext.registerReceiver(this.mReceiver, this.mFilter) != null) {
            this.mEnabled = true;
        }
        return this.mEnabled;
    }

    void stop() {
        if (this.mEnabled) {
            this.mAppContext.unregisterReceiver(this.mReceiver);
            this.mEnabled = false;
        }
    }

    @VisibleForTesting
    void onReceive(Intent intent) {
        int max;
        if (!intent.getAction().equals("android.intent.action.BATTERY_CHANGED")) {
            Log.e((String)TAG, (String)"Unexpected intent.");
            return;
        }
        boolean present = this.mIgnoreBatteryPresentState ? true : intent.getBooleanExtra("present", false);
        int pluggedStatus = intent.getIntExtra("plugged", -1);
        if (!present || pluggedStatus == -1) {
            this.mCallback.onBatteryStatusChanged(new BatteryStatus());
            return;
        }
        int current = intent.getIntExtra("level", -1);
        double level = (double)current / (double)(max = intent.getIntExtra("scale", -1));
        if (level < 0.0 || level > 1.0) {
            level = 1.0;
        }
        boolean charging = pluggedStatus != 0;
        int status = intent.getIntExtra("status", -1);
        boolean batteryFull = status == 5;
        double chargingTimeSeconds = charging && batteryFull ? 0.0 : Double.POSITIVE_INFINITY;
        double dischargingTimeSeconds = Double.POSITIVE_INFINITY;
        BatteryStatus batteryStatus = new BatteryStatus();
        batteryStatus.charging = charging;
        batteryStatus.chargingTime = chargingTimeSeconds;
        batteryStatus.dischargingTime = dischargingTimeSeconds;
        batteryStatus.level = level;
        if (this.mAndroidBatteryManager != null) {
            this.updateBatteryStatusForLollipop(batteryStatus);
        }
        this.mCallback.onBatteryStatusChanged(batteryStatus);
    }

    @TargetApi(value=21)
    private void updateBatteryStatusForLollipop(BatteryStatus batteryStatus) {
        assert (this.mAndroidBatteryManager != null);
        double remainingCapacityRatio = (double)this.mAndroidBatteryManager.getIntProperty(4) / 100.0;
        double batteryCapacityMicroAh = this.mAndroidBatteryManager.getIntProperty(1);
        double averageCurrentMicroA = this.mAndroidBatteryManager.getIntProperty(3);
        if (batteryStatus.charging) {
            if (batteryStatus.chargingTime == Double.POSITIVE_INFINITY && averageCurrentMicroA > 0.0) {
                double chargeFromEmptyHours = batteryCapacityMicroAh / averageCurrentMicroA;
                batteryStatus.chargingTime = Math.ceil((1.0 - remainingCapacityRatio) * chargeFromEmptyHours * 3600.0);
            }
        } else if (averageCurrentMicroA < 0.0) {
            double dischargeFromFullHours = batteryCapacityMicroAh / -averageCurrentMicroA;
            batteryStatus.dischargingTime = Math.floor(remainingCapacityRatio * dischargeFromFullHours * 3600.0);
        }
    }

    @VisibleForTesting
    static class AndroidBatteryManagerWrapper {
        private final BatteryManager mBatteryManager;

        protected AndroidBatteryManagerWrapper(BatteryManager batteryManager) {
            this.mBatteryManager = batteryManager;
        }

        public int getIntProperty(int id2) {
            return this.mBatteryManager.getIntProperty(id2);
        }
    }

    static interface BatteryStatusCallback {
        public void onBatteryStatusChanged(BatteryStatus var1);
    }
}

