/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.system;

import java.util.List;
import org.chromium.mojo.system.AsyncWaiter;
import org.chromium.mojo.system.DataPipe;
import org.chromium.mojo.system.Flags;
import org.chromium.mojo.system.Handle;
import org.chromium.mojo.system.MessagePipeHandle;
import org.chromium.mojo.system.Pair;
import org.chromium.mojo.system.RunLoop;
import org.chromium.mojo.system.SharedBufferHandle;
import org.chromium.mojo.system.UntypedHandle;

public interface Core {
    public static final long DEADLINE_INFINITE = -1L;

    public long getTimeTicksNow();

    public WaitResult wait(Handle var1, HandleSignals var2, long var3);

    public WaitManyResult waitMany(List<Pair<Handle, HandleSignals>> var1, long var2);

    public Pair<MessagePipeHandle, MessagePipeHandle> createMessagePipe(MessagePipeHandle.CreateOptions var1);

    public Pair<DataPipe.ProducerHandle, DataPipe.ConsumerHandle> createDataPipe(DataPipe.CreateOptions var1);

    public SharedBufferHandle createSharedBuffer(SharedBufferHandle.CreateOptions var1, long var2);

    public UntypedHandle acquireNativeHandle(int var1);

    public AsyncWaiter getDefaultAsyncWaiter();

    public RunLoop createDefaultRunLoop();

    public RunLoop getCurrentRunLoop();

    public static class WaitManyResult {
        private int mMojoResult;
        private int mHandleIndex;
        private List<HandleSignalsState> mSignalStates;

        public int getMojoResult() {
            return this.mMojoResult;
        }

        public void setMojoResult(int mojoResult) {
            this.mMojoResult = mojoResult;
        }

        public int getHandleIndex() {
            return this.mHandleIndex;
        }

        public void setHandleIndex(int handleIndex) {
            this.mHandleIndex = handleIndex;
        }

        public List<HandleSignalsState> getSignalStates() {
            return this.mSignalStates;
        }

        public void setSignalStates(List<HandleSignalsState> signalStates) {
            this.mSignalStates = signalStates;
        }
    }

    public static class WaitResult {
        private int mMojoResult;
        private HandleSignalsState mHandleSignalsState;

        public int getMojoResult() {
            return this.mMojoResult;
        }

        public void setMojoResult(int mojoResult) {
            this.mMojoResult = mojoResult;
        }

        public HandleSignalsState getHandleSignalsState() {
            return this.mHandleSignalsState;
        }

        public void setHandleSignalsState(HandleSignalsState handleSignalsState) {
            this.mHandleSignalsState = handleSignalsState;
        }
    }

    public static class HandleSignalsState {
        private final HandleSignals mSatisfiedSignals;
        private final HandleSignals mSatisfiableSignals;

        public HandleSignalsState(HandleSignals satisfiedSignals, HandleSignals satisfiableSignals) {
            this.mSatisfiedSignals = satisfiedSignals;
            this.mSatisfiableSignals = satisfiableSignals;
        }

        public HandleSignals getSatisfiedSignals() {
            return this.mSatisfiedSignals;
        }

        public HandleSignals getSatisfiableSignals() {
            return this.mSatisfiableSignals;
        }
    }

    public static class HandleSignals
    extends Flags<HandleSignals> {
        private static final int FLAG_NONE = 0;
        private static final int FLAG_READABLE = 1;
        private static final int FLAG_WRITABLE = 2;
        private static final int FLAG_PEER_CLOSED = 4;
        public static final HandleSignals NONE = (HandleSignals)HandleSignals.none().immutable();
        public static final HandleSignals READABLE = (HandleSignals)HandleSignals.none().setReadable(true).immutable();
        public static final HandleSignals WRITABLE = (HandleSignals)HandleSignals.none().setWritable(true).immutable();

        public HandleSignals(int signals) {
            super(signals);
        }

        public HandleSignals setReadable(boolean readable) {
            return (HandleSignals)this.setFlag(1, readable);
        }

        public HandleSignals setWritable(boolean writable) {
            return (HandleSignals)this.setFlag(2, writable);
        }

        public HandleSignals setPeerClosed(boolean peerClosed) {
            return (HandleSignals)this.setFlag(4, peerClosed);
        }

        public static HandleSignals none() {
            return new HandleSignals(0);
        }
    }
}

