/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.gfx;

import android.graphics.Bitmap;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="gfx")
public class BitmapHelper {
    @CalledByNative
    private static Bitmap createBitmap(int width, int height, int bitmapFormatValue) {
        Bitmap.Config bitmapConfig = BitmapHelper.getBitmapConfigForFormat(bitmapFormatValue);
        return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)bitmapConfig);
    }

    @CalledByNative
    private static int getBitmapFormatForConfig(Bitmap.Config bitmapConfig) {
        switch (bitmapConfig) {
            case ALPHA_8: {
                return 1;
            }
            case ARGB_4444: {
                return 2;
            }
            case ARGB_8888: {
                return 3;
            }
            case RGB_565: {
                return 4;
            }
        }
        return 0;
    }

    private static Bitmap.Config getBitmapConfigForFormat(int bitmapFormatValue) {
        switch (bitmapFormatValue) {
            case 1: {
                return Bitmap.Config.ALPHA_8;
            }
            case 2: {
                return Bitmap.Config.ARGB_4444;
            }
            case 4: {
                return Bitmap.Config.RGB_565;
            }
        }
        return Bitmap.Config.ARGB_8888;
    }

    @CalledByNative
    private static int getByteCount(Bitmap bitmap) {
        return bitmap.getByteCount();
    }
}

