/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.resources.dynamics;

import android.graphics.Bitmap;
import android.graphics.Rect;
import org.chromium.ui.resources.dynamics.DynamicResource;

public class BitmapDynamicResource
implements DynamicResource {
    private static final Rect EMPTY_RECT = new Rect();
    private final int mResId;
    private Bitmap mBitmap;
    private final Rect mSize = new Rect();
    private boolean mIsDirty = true;

    public BitmapDynamicResource(int resourceId) {
        this.mResId = resourceId;
    }

    public int getResId() {
        return this.mResId;
    }

    public void setBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        this.mIsDirty = true;
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
        }
        this.mBitmap = bitmap;
        this.mSize.set(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
    }

    @Override
    public Bitmap getBitmap() {
        this.mIsDirty = false;
        return this.mBitmap;
    }

    @Override
    public Rect getBitmapSize() {
        return this.mSize;
    }

    @Override
    public Rect getPadding() {
        return EMPTY_RECT;
    }

    @Override
    public Rect getAperture() {
        return EMPTY_RECT;
    }

    @Override
    public boolean isDirty() {
        return this.mIsDirty;
    }
}

