/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.resources.sprites;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.util.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.chromium.base.TraceEvent;
import org.chromium.base.VisibleForTesting;
import org.chromium.ui.resources.Resource;

public class CrushedSpriteResource
implements Resource {
    private static final Rect EMPTY_RECT = new Rect();
    private Bitmap mBitmap;
    private final Rect mBitmapSize = new Rect();
    private float mScaledSpriteWidth;
    private float mScaledSpriteHeight;
    private int mUnscaledSpriteWidth;
    private int mUnscaledSpriteHeight;
    private int[][] mRectangles;

    public CrushedSpriteResource(int bitmapResId, int metadataResId, Resources resources) {
        this.mBitmap = CrushedSpriteResource.loadBitmap(bitmapResId, resources);
        if (this.mBitmap != null) {
            this.mBitmapSize.set(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
            try {
                TraceEvent.begin("CrushedSpriteResource.parseMetadata");
                this.parseMetadata(metadataResId, this.mBitmap.getDensity(), resources);
                TraceEvent.end("CrushedSpriteResource.parseMetadata");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Bitmap loadBitmap(int bitmapResId, Resources resources) {
        TraceEvent.begin("CrushedSpriteResource.loadBitmap");
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inScaled = false;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)resources, (int)bitmapResId, (BitmapFactory.Options)opts);
        TraceEvent.end("CrushedSpriteResource.loadBitmap");
        return bitmap;
    }

    @Override
    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    @Override
    public Rect getBitmapSize() {
        return this.mBitmapSize;
    }

    @Override
    public Rect getPadding() {
        return EMPTY_RECT;
    }

    @Override
    public Rect getAperture() {
        return EMPTY_RECT;
    }

    public float getScaledSpriteWidth() {
        return this.mScaledSpriteWidth;
    }

    public float getScaledSpriteHeight() {
        return this.mScaledSpriteHeight;
    }

    public int getUnscaledSpriteWidth() {
        return this.mUnscaledSpriteWidth;
    }

    public int getUnscaledSpriteHeight() {
        return this.mUnscaledSpriteHeight;
    }

    public int[][] getFrameRectangles() {
        return (int[][])this.mRectangles.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void parseMetadata(int metadataResId, int bitmapDensity, Resources resources) throws IOException {
        InputStream inputStream = resources.openRawResource(metadataResId);
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream));
        try {
            reader.beginObject();
            String name = reader.nextName();
            assert (name.equals("apiVersion"));
            String version = reader.nextString();
            assert (version.equals("1.0"));
            float dpToPx = resources.getDisplayMetrics().density;
            name = reader.nextName();
            assert (name.equals("scaledSpriteWidthDp"));
            this.mScaledSpriteWidth = (float)reader.nextInt() * dpToPx;
            name = reader.nextName();
            assert (name.equals("scaledSpriteHeightDp"));
            this.mScaledSpriteHeight = (float)reader.nextInt() * dpToPx;
            name = reader.nextName();
            assert (name.equals("densities"));
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginObject();
                boolean foundDensity = this.parseMetadataForDensity(reader, bitmapDensity);
                reader.endObject();
                if (!foundDensity) continue;
                break;
            }
        }
        finally {
            reader.close();
            inputStream.close();
        }
    }

    private boolean parseMetadataForDensity(JsonReader reader, int bitmapDensity) throws IOException {
        String name = reader.nextName();
        assert (name.equals("density"));
        int density = reader.nextInt();
        if (density != bitmapDensity) {
            reader.skipValue();
            reader.skipValue();
            reader.skipValue();
            reader.skipValue();
            reader.skipValue();
            reader.skipValue();
            return false;
        }
        name = reader.nextName();
        assert (name.equals("width"));
        this.mUnscaledSpriteWidth = reader.nextInt();
        name = reader.nextName();
        assert (name.equals("height"));
        this.mUnscaledSpriteHeight = reader.nextInt();
        name = reader.nextName();
        assert (name.equals("rectangles"));
        this.parseFrameRectangles(reader);
        return true;
    }

    private void parseFrameRectangles(JsonReader reader) throws IOException {
        ArrayList allFrameRectangles = new ArrayList();
        int frameCount = 0;
        reader.beginArray();
        while (reader.hasNext()) {
            ArrayList<Integer> frameRectangles = new ArrayList<Integer>();
            reader.beginArray();
            while (reader.hasNext()) {
                frameRectangles.add(reader.nextInt());
            }
            reader.endArray();
            allFrameRectangles.add(frameRectangles);
            ++frameCount;
        }
        reader.endArray();
        this.mRectangles = new int[frameCount][];
        for (int i = 0; i < frameCount; ++i) {
            ArrayList frameRectangles = (ArrayList)allFrameRectangles.get(i);
            int[] frameRectanglesArray = new int[frameRectangles.size()];
            for (int j = 0; j < frameRectangles.size(); ++j) {
                frameRectanglesArray[j] = (Integer)frameRectangles.get(j);
            }
            this.mRectangles[i] = frameRectanglesArray;
        }
    }
}

