/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import org.xwalk.core.internal.ReflectMethod;
import org.xwalk.core.internal.XWalkCoreBridge;
import org.xwalk.core.internal.XWalkExtensionInternal;

public class XWalkExtensionBridge
extends XWalkExtensionInternal {
    private XWalkCoreBridge coreBridge;
    private Object wrapper;
    private ReflectMethod postMessageintStringMethod = new ReflectMethod(null, "postMessage", new Class[0]);
    private ReflectMethod postBinaryMessageintbyteArrayMethod = new ReflectMethod(null, "postBinaryMessage", new Class[0]);
    private ReflectMethod broadcastMessageStringMethod = new ReflectMethod(null, "broadcastMessage", new Class[0]);
    private ReflectMethod onInstanceCreatedintMethod = new ReflectMethod(null, "onInstanceCreated", new Class[0]);
    private ReflectMethod onInstanceDestroyedintMethod = new ReflectMethod(null, "onInstanceDestroyed", new Class[0]);
    private ReflectMethod onBinaryMessageintbyteArrayMethod = new ReflectMethod(null, "onBinaryMessage", new Class[0]);
    private ReflectMethod onMessageintStringMethod = new ReflectMethod(null, "onMessage", new Class[0]);
    private ReflectMethod onSyncMessageintStringMethod = new ReflectMethod(null, "onSyncMessage", new Class[0]);

    public Object getWrapper() {
        return this.wrapper;
    }

    public XWalkExtensionBridge(String name, String jsApi, Object wrapper) {
        super(name, jsApi);
        this.wrapper = wrapper;
        this.reflectionInit();
    }

    public XWalkExtensionBridge(String name, String jsApi, String[] entryPoints, Object wrapper) {
        super(name, jsApi, entryPoints);
        this.wrapper = wrapper;
        this.reflectionInit();
    }

    @Override
    public void postMessage(int instanceID, String message) {
        if (this.postMessageintStringMethod == null || this.postMessageintStringMethod.isNull()) {
            this.postMessageSuper(instanceID, message);
        } else {
            this.postMessageintStringMethod.invoke(instanceID, message);
        }
    }

    public void postMessageSuper(int instanceID, String message) {
        super.postMessage(instanceID, message);
    }

    @Override
    public void postBinaryMessage(int instanceID, byte[] message) {
        if (this.postBinaryMessageintbyteArrayMethod == null || this.postBinaryMessageintbyteArrayMethod.isNull()) {
            this.postBinaryMessageSuper(instanceID, message);
        } else {
            this.postBinaryMessageintbyteArrayMethod.invoke(instanceID, message);
        }
    }

    public void postBinaryMessageSuper(int instanceID, byte[] message) {
        super.postBinaryMessage(instanceID, message);
    }

    @Override
    public void broadcastMessage(String message) {
        if (this.broadcastMessageStringMethod == null || this.broadcastMessageStringMethod.isNull()) {
            this.broadcastMessageSuper(message);
        } else {
            this.broadcastMessageStringMethod.invoke(message);
        }
    }

    public void broadcastMessageSuper(String message) {
        super.broadcastMessage(message);
    }

    @Override
    public void onInstanceCreated(int instanceID) {
        if (this.onInstanceCreatedintMethod == null || this.onInstanceCreatedintMethod.isNull()) {
            this.onInstanceCreatedSuper(instanceID);
        } else {
            this.onInstanceCreatedintMethod.invoke(instanceID);
        }
    }

    public void onInstanceCreatedSuper(int instanceID) {
        super.onInstanceCreated(instanceID);
    }

    @Override
    public void onInstanceDestroyed(int instanceID) {
        if (this.onInstanceDestroyedintMethod == null || this.onInstanceDestroyedintMethod.isNull()) {
            this.onInstanceDestroyedSuper(instanceID);
        } else {
            this.onInstanceDestroyedintMethod.invoke(instanceID);
        }
    }

    public void onInstanceDestroyedSuper(int instanceID) {
        super.onInstanceDestroyed(instanceID);
    }

    @Override
    public void onBinaryMessage(int instanceID, byte[] message) {
        if (this.onBinaryMessageintbyteArrayMethod == null || this.onBinaryMessageintbyteArrayMethod.isNull()) {
            this.onBinaryMessageSuper(instanceID, message);
        } else {
            this.onBinaryMessageintbyteArrayMethod.invoke(instanceID, message);
        }
    }

    public void onBinaryMessageSuper(int instanceID, byte[] message) {
        super.onBinaryMessage(instanceID, message);
    }

    @Override
    public void onMessage(int instanceID, String message) {
        this.onMessageintStringMethod.invoke(instanceID, message);
    }

    @Override
    public String onSyncMessage(int instanceID, String message) {
        return (String)this.onSyncMessageintStringMethod.invoke(instanceID, message);
    }

    void reflectionInit() {
        this.coreBridge = XWalkCoreBridge.getInstance();
        if (this.coreBridge == null) {
            return;
        }
        this.postMessageintStringMethod.init(this.wrapper, null, "postMessage", Integer.TYPE, String.class);
        this.postBinaryMessageintbyteArrayMethod.init(this.wrapper, null, "postBinaryMessage", Integer.TYPE, byte[].class);
        this.broadcastMessageStringMethod.init(this.wrapper, null, "broadcastMessage", String.class);
        this.onInstanceCreatedintMethod.init(this.wrapper, null, "onInstanceCreated", Integer.TYPE);
        this.onInstanceDestroyedintMethod.init(this.wrapper, null, "onInstanceDestroyed", Integer.TYPE);
        this.onBinaryMessageintbyteArrayMethod.init(this.wrapper, null, "onBinaryMessage", Integer.TYPE, byte[].class);
        this.onMessageintStringMethod.init(this.wrapper, null, "onMessage", Integer.TYPE, String.class);
        this.onSyncMessageintStringMethod.init(this.wrapper, null, "onSyncMessage", Integer.TYPE, String.class);
    }
}

