/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.AndroidRuntimeException;
import android.util.Log;
import java.util.HashMap;
import org.xwalk.core.internal.XWalkContentsClientBridge;
import org.xwalk.core.internal.XWalkNotificationService;
import org.xwalk.core.internal.XWalkViewInternal;

public class XWalkNotificationServiceImpl
implements XWalkNotificationService {
    private static final String TAG = "XWalkNotificationServiceImpl";
    private static final String XWALK_ACTION_CLICK_NOTIFICATION_SUFFIX = ".notification.click";
    private static final String XWALK_ACTION_CLOSE_NOTIFICATION_SUFFIX = ".notification.close";
    private static final String XWALK_INTENT_EXTRA_KEY_NOTIFICATION_ID = "xwalk.NOTIFICATION_ID";
    private static final String XWALK_INTENT_CATEGORY_NOTIFICATION_PREFIX = "notification_";
    private Context mContext;
    private XWalkContentsClientBridge mBridge;
    private XWalkViewInternal mView;
    private NotificationManager mNotificationManager;
    private BroadcastReceiver mNotificationCloseReceiver;
    private HashMap<Integer, WebNotification> mExistNotificationIds;
    private HashMap<String, WebNotification> mExistReplaceIds;

    public XWalkNotificationServiceImpl(Context context, XWalkViewInternal view) {
        this.mContext = context;
        this.mView = view;
        this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        this.mNotificationCloseReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                XWalkNotificationServiceImpl.this.mView.onNewIntent(intent);
            }
        };
        this.mExistNotificationIds = new HashMap();
        this.mExistReplaceIds = new HashMap();
    }

    private static String getCategoryFromNotificationId(int id2) {
        return XWALK_INTENT_CATEGORY_NOTIFICATION_PREFIX + id2;
    }

    @Override
    public void setBridge(XWalkContentsClientBridge bridge) {
        this.mBridge = bridge;
    }

    @Override
    public void shutdown() {
        if (!this.mExistNotificationIds.isEmpty()) {
            this.unregisterReceiver();
        }
        this.mBridge = null;
    }

    @Override
    public boolean maybeHandleIntent(Intent intent) {
        if (intent.getAction() == null) {
            return false;
        }
        int notificationId = intent.getIntExtra(XWALK_INTENT_EXTRA_KEY_NOTIFICATION_ID, -1);
        if (notificationId <= 0) {
            return false;
        }
        if (intent.getAction().equals(this.mView.getContext().getPackageName() + XWALK_ACTION_CLOSE_NOTIFICATION_SUFFIX)) {
            this.onNotificationClose(notificationId, true);
            return true;
        }
        if (intent.getAction().equals(this.mView.getContext().getPackageName() + XWALK_ACTION_CLICK_NOTIFICATION_SUFFIX)) {
            this.onNotificationClick(notificationId);
            return true;
        }
        return false;
    }

    public Bitmap getNotificationIcon(Bitmap icon) {
        if (icon == null) {
            return null;
        }
        int originalWidth = icon.getWidth();
        int originalHeight = icon.getHeight();
        if (originalWidth == 0 || originalHeight == 0) {
            return icon;
        }
        int targetWidth = this.mContext.getResources().getDimensionPixelSize(0x1050005);
        int targetHeight = this.mContext.getResources().getDimensionPixelSize(17104902);
        if (originalWidth > targetWidth && originalHeight > targetHeight) {
            if (originalWidth * targetHeight > originalHeight * targetWidth) {
                targetHeight = originalHeight * targetWidth / originalWidth;
            } else {
                targetWidth = originalWidth * targetHeight / originalHeight;
            }
        }
        return Bitmap.createScaledBitmap((Bitmap)icon, (int)targetWidth, (int)targetHeight, (boolean)true);
    }

    @Override
    public void showNotification(String title, String message, String replaceId, Bitmap icon, int notificationId) {
        Notification.Builder builder;
        WebNotification webNotification;
        if (!replaceId.isEmpty() && this.mExistReplaceIds.containsKey(replaceId)) {
            webNotification = this.mExistReplaceIds.get(replaceId);
            notificationId = webNotification.mNotificationId;
            builder = webNotification.mBuilder;
            WebNotification webNotification2 = webNotification;
            webNotification2.mMessageNum = webNotification2.mMessageNum + 1;
            builder.setNumber(webNotification2.mMessageNum.intValue());
        } else {
            builder = new Notification.Builder(this.mContext.getApplicationContext()).setAutoCancel(true);
            webNotification = new WebNotification();
            webNotification.mNotificationId = notificationId;
            webNotification.mReplaceId = replaceId;
            webNotification.mBuilder = builder;
            this.mExistNotificationIds.put(notificationId, webNotification);
            if (!replaceId.isEmpty()) {
                this.mExistReplaceIds.put(replaceId, webNotification);
            }
        }
        builder.setContentTitle((CharSequence)title);
        builder.setContentText((CharSequence)message);
        int iconRes = this.mContext.getApplicationInfo().icon;
        if (iconRes == 0) {
            iconRes = 17301651;
        }
        builder.setSmallIcon(iconRes);
        Bitmap bigIcon = this.getNotificationIcon(icon);
        if (bigIcon != null) {
            builder.setLargeIcon(bigIcon);
        }
        Context context = this.mView.getContext();
        String category = XWalkNotificationServiceImpl.getCategoryFromNotificationId(notificationId);
        Intent clickIntent = new Intent(context, context.getClass()).setAction(context.getPackageName() + XWALK_ACTION_CLICK_NOTIFICATION_SUFFIX).putExtra(XWALK_INTENT_EXTRA_KEY_NOTIFICATION_ID, notificationId).setFlags(0x20100000).addCategory(category);
        Intent closeIntent = new Intent(context.getPackageName() + XWALK_ACTION_CLOSE_NOTIFICATION_SUFFIX).putExtra(XWALK_INTENT_EXTRA_KEY_NOTIFICATION_ID, notificationId).addCategory(category);
        builder.setContentIntent(PendingIntent.getActivity((Context)context, (int)0, (Intent)clickIntent, (int)0x8000000));
        builder.setDeleteIntent(PendingIntent.getBroadcast((Context)context, (int)0, (Intent)closeIntent, (int)0x8000000));
        this.doShowNotification(notificationId, Build.VERSION.SDK_INT >= 16 ? builder.build() : builder.getNotification());
        this.notificationChanged();
        this.onNotificationShown(notificationId);
    }

    @Override
    public void cancelNotification(int notificationId) {
        this.mNotificationManager.cancel(notificationId);
        this.onNotificationClose(notificationId, false);
    }

    public void doShowNotification(int notificationId, Notification notification) {
        this.mNotificationManager.notify(notificationId, notification);
    }

    public void onNotificationShown(int notificationId) {
        WebNotification webNotification = this.mExistNotificationIds.get(notificationId);
        if (webNotification == null) {
            return;
        }
        if (this.mBridge != null) {
            this.mBridge.notificationDisplayed(notificationId);
        }
    }

    public void onNotificationClick(int notificationId) {
        WebNotification webNotification = this.mExistNotificationIds.get(notificationId);
        if (webNotification == null) {
            return;
        }
        this.mExistNotificationIds.remove(notificationId);
        this.mExistReplaceIds.remove(webNotification.mReplaceId);
        this.notificationChanged();
        if (this.mBridge != null) {
            this.mBridge.notificationClicked(notificationId);
        }
    }

    public void onNotificationClose(int notificationId, boolean byUser) {
        WebNotification webNotification = this.mExistNotificationIds.get(notificationId);
        if (webNotification == null) {
            return;
        }
        this.mExistNotificationIds.remove(notificationId);
        this.mExistReplaceIds.remove(webNotification.mReplaceId);
        this.notificationChanged();
        if (this.mBridge != null) {
            this.mBridge.notificationClosed(notificationId, byUser);
        }
    }

    private void notificationChanged() {
        if (this.mExistNotificationIds.isEmpty()) {
            Log.i((String)TAG, (String)"notifications are all cleared,unregister broadcast receiver for close pending intent");
            this.unregisterReceiver();
        } else {
            this.registerReceiver();
        }
    }

    private void registerReceiver() {
        IntentFilter filter = new IntentFilter(this.mView.getContext().getPackageName() + XWALK_ACTION_CLOSE_NOTIFICATION_SUFFIX);
        for (Integer id2 : this.mExistNotificationIds.keySet()) {
            filter.addCategory(XWalkNotificationServiceImpl.getCategoryFromNotificationId(id2));
        }
        try {
            this.mView.getContext().registerReceiver(this.mNotificationCloseReceiver, filter);
        }
        catch (AndroidRuntimeException e) {
            Log.w((String)TAG, (String)e.getLocalizedMessage());
        }
    }

    private void unregisterReceiver() {
        this.mView.getContext().unregisterReceiver(this.mNotificationCloseReceiver);
    }

    private class WebNotification {
        public Integer mNotificationId;
        public String mReplaceId;
        public Notification.Builder mBuilder;
        public Integer mMessageNum = 1;

        WebNotification() {
        }
    }
}

