package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;

public class GetFavoriteGroupJSON extends AcmsCommonJSON {

    public List<Integer> favoriteGroupIds;

    public GetFavoriteGroupJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {
        favoriteGroupIds = new ArrayList<Integer>();
        if (!json.has(ABookCommConstants.KEY.BODY)) { return; }

        JSONObject responseBodyObject = json.getJSONObject(ABookCommConstants.KEY.BODY);
        if (responseBodyObject == null) { return; }
        JSONArray favoriteIds = responseBodyObject.getJSONArray(ABookCommConstants.KEY.FAVORITE_GROUP_IDS);

        if (favoriteIds == null || favoriteIds.length() == 0) {
            return;
        }

        for (int count = 0; count < favoriteIds.length(); count++) {
            favoriteGroupIds.add((Integer)favoriteIds.get(count));
        }
    }
}

