package jp.agentec.abook.abv.bl.acms.client.json.content;

import jp.agentec.abook.abv.bl.common.util.JsonUtil;

import org.json.adf.JSONObject;

/**
 * コンテンツリンクの情報を格納します。
 * @author tauchi
 */
public class ContentLinkJSON {
	public static final String CONTENT_NAME = "contentName";
	public static final String CONTENT_ID = "contentId";
	
	private JSONObject contentLinkJson;
	
	public ContentLinkJSON(JSONObject contentLinkJson) {
		this.contentLinkJson = contentLinkJson;
	}
	
	/**
	 * コンテンツ名を取得します。
	 * （JSONに入っていない場合nullを返す）
	 * 
	 * @return contentName
	 */
	public String getContentName() {
		return JsonUtil.getString(contentLinkJson, CONTENT_NAME);
	}
	
	/**
	 * コンテンツIDを取得します。
	 * @return contentId
	 */
	public long getContentId() { // ない場合は-1を返す
		return JsonUtil.getLong(contentLinkJson, CONTENT_ID);
	}
}
