package jp.agentec.abook.abv.bl.acms.type;

import jp.agentec.abook.abv.bl.common.Constant;
import jp.agentec.adf.util.StringUtil;

/**
 * ACMS APIのURL及びメソッド名を管理します。
 * @author Taejin Hong
 * @version 1.1.0
 */
public class AcmsApis {
	/**
	 * 要認証APIのURLフォーマット<br>
	 * 以下のフォーマットになります。<br>
	 * {host}/{url_path}/abvapi/{method}/
	 * @since 1.0.0
	 */
	public static final String AbvApiUrlFormat = "%s/%s/abvapi/%s/";

	/**
	 * 認証なしAPIのURLフォーマット<br>
	 * 以下のフォーマットになります。<br>
	 * {host}/nuabvapi/{method}/
	 * @since 1.1.0
	 */
	public static final String NuabvapiFormat = "%s/nuabvapi/%s/";

	/**
	 * ABookCheck用のApi
	 *要認証APIのURLフォーマット<br>
	 * 以下のフォーマットになります。<br>
	 * {host}/{url_path}/checkapi/{method}/
	 */
	public static final String CheckApiUrlFormat = "%s/%s/checkapi/%s/";

	/**
	 * モバイルデバイスからのログインで、初ログインの際に使う<br>
	 * ACMS1.6に対応
	 * @since 1.1.0
	 */
	public static final String ApiUrlNewAppStoreLogin = "newAppStoreLogin";

	public static final String ApiUrlAppStoreNewLogin = "appStoreNewLogin";

	/**
	 * モバイルデバイスからのログインで、２回目からのログインに使う<br>
	 * ACMS1.6に対応
	 * @since 1.1.0
	 */
	public static final String ApiUrlEnterpriseLogin = "enterpriseLogin";
	/**
	 * モバイルデバイスからのログインで、MACアドレスの代わりにUUIDを使う<br>
	 * ACMS1.4に対応
	 * @since 1.1.0
	 */
	public static final String ApiUrlEnterpriseNewLogin = "enterpriseNewLogin";
	
	/**
	 * ジャンル一覧ぼ取得
	 * @since 1.0.0
	 */
	public static final String ApiUrlCategory = "category";
	/**
	 * ログインしたユーザのグループ一覧を取得
	 * @since 1.0.0
	 */
	public static final String ApiUrlGroup = "group";
	/**
	 * コンテンツＩＤとバージョン情報を取得
	 * @since 1.0.0
	 */
	public static final String ApiUrlContentVersion = "contentVersion";
	/**
	 * コンテンツダウンロードに関するログを記録
	 * @since 1.0.0
	 */
	public static final String ApiUrlContentDownloadLog = "contentDownloadLog";
	/**
	 * コンテンツ閲覧に関するログを記録
	 * @since 1.0.0
	 */
	public static final String ApiUrlContentReadingLog = "contentReadingLog";
	/**
	 * SIDチェック
	 * @since 1.0.0
	 */
	public static final String ApiUrlCheckSid = "checkSid";
	/**
	 * ログインしたユーザのパスワードを変更
	 * @since 1.0.0
	 */
	public static final String ApiUrlPasswordChange = "passwordChange";
	/**
	 * ログインしたユーザが所属する事業者のサービスオプションを取得
	 * @since 1.0.0
	 */
	public static final String ApiUrlServiceOption = "serviceOption";
	/**
	 * ログインしたユーザが所属する事業者のアプリ最新バージョンを取得
	 * @since 1.0.0
	 */
	public static final String ApiUrlAppLatestVersion = "appLatestVersion";
	/**
	 * ログインしたユーザのコンテンツが公開されたか確認
	 * @since 1.0.0
	 */
	public static final String ApiUrlContentCheckDeliverable = "contentCheckDeliverable";
	/**
	 * パスワード変更が必要かどうかを取得
	 * @since 1.0.0
	 */
	public static final String ApiUrlRequirePasswordChange = "requirePasswordChange";
	/**
	 * サーバの現在時間を取得
	 * @since 1.0.0
	 */
	public static final String ApiUrlServerTime = "serverTime";
	
	/**
	 * サーバのタイムゾーンを取得
	 */
	public static final String ApiUrlServerTimeZone = "serverTimeZone";
	
	//앙케이트 응답 내용을 서버에 송신
	public static final String ApiUrlEnqueteReply = "enqueteReply";
	
	public static final String ApiUrlUploadLogFile = "uploadLogFile";

	public static final String ApiUrlGetAuthLevel = "getAuthLevel";
	
	public static final String ApiUrlAddMemberGroup = "addMemberGroup";
	
	// デバイストークン更新
	public static final String ApiUrlUpdateDeviceToken = "updateDeviceToken";
	// プロジェクト一覧取得
	public static final String ApiOperationList = "operationList";
	// 作業者グループ取得
	public static final String ApiWorkingGroupList = "workingGroupList";
	// 作業データ送信
	public static final String ApiSendTaskData = "taskData";
	// 作業データ取得
	public static final String ApiGetOperationData = "getOperationData";
	// 作業ファイル取得
	public static final String ApiGetTaskFile = "getTaskFile";
	// コンテンツ登録
	public static final String ApiTaskContentEntry = "taskContentEntry";
	// シーン登録
	public static final String ApiSceneEntry = "sceneEntry";
    // プッシュメッセージ送信
    public static final String ApiSendPushMessage = "sendPushMessage";
    // プッシュメッセージ定型文取得
    public static final String ApiGetPushMessages = "getPushMessage";
    // 定期点検データ送信
    public static final String ApiSendRoutineTaskData = "routineTaskData";
	// 作業種別データ取得
	public static final String ApiOperationGroupMaster = "operationGroupMaster";
	// 絞り検索マスタデータ取得
	public static final String ApiGetApertureMasterData = "getApertureMasterData";
	// 簡易帳票一覧取得
	public static final String ApiQuickReportSearch = "quickReportSearch";
	// 簡易帳票リビジョン一覧取得
	public static final String ApiQuickReportRevision = "quickReportRevision";

	// 連続作業の承認情報取得
	public static final String ApiGetProcessData = "getProcessData";

	// 連続作業の全工程の全削除の送信
	 public static final String ApiDeleteProcess = "deleteProcess";

	// チャット
	public static final String ChatApiUrlFormat = "%s/%s/chatapi/%s/";
	public static final String ApiGetChatPushData = "push";
	public static final String ApigetChatRooms = "room";
	public static final String ApigetUser = "user";
	public static final String ApigetMessage = "message";
	public static final String ApigetFavorite = "favorite";
	public static final String ApigetArchive = "archive";
	public static final String ApigetCollaboration = "collaboration";

	public static final class UserCmds {
		public static final String inviteUsers = "3";
		public static final String getMyInfo = "9";
		public static final String getGroupInfo = "10";
		public static final String getNameCard = "11";
	}

	public static final class RoomCmds {
		public static final String getRoomList = "5";
		public static final String createRoom = "2";
		public static final String changeRoomName = "6";
	}

	public static final class MessageCmds {
		public static final String getMessages = "2";
	}

	public static final class FavoriteCmds {
		public static final String addFavoriteUser = "1";
		public static final String addFavoriteGroup = "2";
		public static final String getFavoriteUser = "4";
		public static final String getFavoriteGroup = "5";
		public static final String removeFavoriteUser = "7";
		public static final String removeFavoriteGroup = "8";
	}

	public static final class ArchiveCmds {
		public static final String getArchive = "1";
		public static final String getArchiveDetail = "2";
	}

	public static final class CollaborationCmds {
		public static final String start = "1";
		public static final String join = "2";
		public static final String finish = "3";
	}

	//	download
	/**
	 * コンテンツのZIPファイルを取得<br>
	 * 以下のフォーマットになります。<br>
	 * {host}/{url_path}/dl/contentZipfile/getContent/{contentId}/{sid}/{zipType}<br>
	 * zipTypeにより取得するZIPファイルが異なります。<br>
	 * zipTypeは {@link ContentZipType} を指定します。
	 * @since 1.0.0
	 */
	public static final String DownloadContentZipFileUrlFormat = "%s/%s/dl/contentZipFile/getContentForAndroid/%d/%s/%d";
	//public static final String DownloadContentZipFileUrlFormat = "%s/%s/dl/contentZipFile/getContent/%d/%s/%d";

	public static final String DownloadApplicationAPKFile = "%s/%s/appdl/downloadApp/android/3/%s/%s";

    /**
     * 端末からログ取得要求があるかどうかを判定する
     * @since 1.8.4
     */
    public static final String CheckSendLogFileFormat = "checkSendLogFile";

	public static final String GetTaskFileUrlFormat = "%s/%s/checkapi/getTaskFile";

	/**
	 * APIのURLを完成します。
	 * @param host ACMSのFQDNです。
	 * @param urlPath 事業者のurl_pathです。
	 * @param methodName 呼び出すAPIのメソッド名です。
	 * @return 完成されたURLを返します。引数に誤りがあると空文字を返します。
	 * @since 1.0.0
	 */
	public static String getApiUrl(String host, String urlPath, String methodName) {
		String url = StringUtil.Empty;
		int apiValue = Constant.ApiValue.abvapi;

		if (StringUtil.isNullOrWhiteSpace(urlPath)) {
			apiValue = Constant.ApiValue.nuapi;
		}

		if (methodName.equals(ApiUrlNewAppStoreLogin) || methodName.equals(ApiUrlAppStoreNewLogin) || methodName.equals(ApiUrlServerTime) || methodName.equals(ApiUrlServerTimeZone)) {
			apiValue = Constant.ApiValue.nuapi;
		} else if (methodName.equals(ApiOperationList) || methodName.equals(ApiWorkingGroupList) || methodName.equals(ApiSendTaskData) || methodName.equals(ApiGetOperationData) ||
				methodName.equals(ApiGetTaskFile) || methodName.equals(ApiSceneEntry) || methodName.equals(ApiTaskContentEntry) ||
				methodName.equals(ApiSendPushMessage) || methodName.equals(ApiGetPushMessages) || methodName.equals(ApiSendRoutineTaskData) ||
				methodName.equals(ApiOperationGroupMaster) || methodName.equals(ApiGetApertureMasterData) || methodName.equals(ApiQuickReportSearch) || methodName.equals(ApiQuickReportRevision)
				|| methodName.equals(ApiGetProcessData) || methodName.equals(ApiDeleteProcess)) {
			apiValue = Constant.ApiValue.checkapi;
		} else if (methodName.equals(ApiGetChatPushData) || methodName.equals(ApigetChatRooms) || methodName.equals(ApigetUser)
				|| methodName.equals(ApigetMessage) || methodName.equals(ApigetFavorite) || methodName.equals(ApigetArchive)
				|| methodName.equals(ApigetCollaboration)) {	// pushActionはchatapiを指定
			apiValue = Constant.ApiValue.chatapi;
		}

		switch (apiValue) {
            case Constant.ApiValue.nuapi:
                //	認証がいらないメソッド
                url = String.format(NuabvapiFormat, StringUtil.trimLastSlashOrSpace(host), methodName);
                break;
            case Constant.ApiValue.abvapi:
                //	認証済みである必要があるメソッド
                url = String.format(AbvApiUrlFormat, StringUtil.trimLastSlashOrSpace(host), StringUtil.trimLastSlashOrSpace(urlPath), methodName);
                break;
			case Constant.ApiValue.checkapi:
				//ABookCheck用のapi
				url = String.format(CheckApiUrlFormat, StringUtil.trimLastSlashOrSpace(host), StringUtil.trimLastSlashOrSpace(urlPath), methodName);
				break;
			case Constant.ApiValue.chatapi:
				// チャットAPI
				url = String.format(ChatApiUrlFormat, StringUtil.trimLastSlashOrSpace(host), StringUtil.trimLastSlashOrSpace(urlPath), methodName);
				break;
        }

		return url;
	}
	/**
	 * ZIPファイルのダウンロードURLを完成します。
	 * @param host ACMSのFQDNです。
	 * @param urlPath 事業者のurl_pathです。
	 * @param contentId ダウンロードするZIPファイルのコンテンツIDです。
	 * @param sid セッションIDです。
	 * @param zipType ダウンロードするZIPファイルの種類です。
	 * @return 完成されたURLを返します。引数に誤りがあると空文字を返します。
	 * @since 1.0.0
	 */
	public static String getDownloadUrl(String host, String urlPath, long contentId, String sid, ContentZipType zipType) {
		String url = StringUtil.Empty;
		
		if (!StringUtil.isNullOrWhiteSpace(host) && !StringUtil.isNullOrWhiteSpace(urlPath) && !StringUtil.isNullOrWhiteSpace(sid) && zipType != null) {
			url = String.format(DownloadContentZipFileUrlFormat, StringUtil.trimLastSlashOrSpace(host), StringUtil.trimLastSlashOrSpace(urlPath), contentId, sid, zipType.type());
		}
		
		return url;
	}

	public static String getDownloadApplicationFileUrl(String host, String urlPath, String sid, String currentDate) {
		String url = StringUtil.Empty;
		if (!StringUtil.isNullOrWhiteSpace(host) && !StringUtil.isNullOrWhiteSpace(urlPath) && !StringUtil.isNullOrWhiteSpace(sid)) {
			url = String.format(DownloadApplicationAPKFile, StringUtil.trimLastSlashOrSpace(host), StringUtil.trimLastSlashOrSpace(urlPath), sid, currentDate);
		}
		return url;
	}

	/**
	 * 作業データファイルのダウンロードURLを完成します。
	 * @param host
	 * @param urlPath
	 * @return
	 */
	public static String getTaskFileUrl(String host, String urlPath) {
		return String.format(GetTaskFileUrlFormat, StringUtil.trimLastSlashOrSpace(host), StringUtil.trimLastSlashOrSpace(urlPath));
	}
}
