package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;
import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;

public class RChatRoomShopMember extends SQLiteTableScript {
	public RChatRoomShopMember() {
	}

	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList();
		StringBuffer sql = new StringBuffer();
		sql.append(" create table r_chat_room_shop_member ( ");
		sql.append("        chat_room_id INTEGER NOT NULL ");
		sql.append("      , shop_member_id INTEGER NOT NULL ");
		sql.append("      , PRIMARY KEY (chat_room_id, shop_member_id) ");
		sql.append(" ) ");
		ddl.add(sql.toString());
		return ddl;
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		List<String> ddl = new ArrayList<String>();
		if (oldVersion < DatabaseVersions.Ver1_3_100) {
			ddl.addAll(getCreateScript(newVersion));
		}
		return ddl;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
		return null;
	}
}