/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.ResultPointCallback;
import oz.util.barcode.client.android.DecodeFormatManager;
import oz.util.barcode.client.android.DecodeHandler;
import oz.util.barcode.client.android.OZCaptureView;

final class DecodeThread
extends Thread {
    public static final String BARCODE_BITMAP = "barcode_bitmap";
    public static final String BARCODE_SCALED_FACTOR = "barcode_scaled_factor";
    private final OZCaptureView activity;
    private final Map hints;
    private Handler handler;
    private final CountDownLatch handlerInitLatch;

    DecodeThread(OZCaptureView oZCaptureView, Collection enumSet, Map map, String string, ResultPointCallback resultPointCallback) {
        this.activity = oZCaptureView;
        this.handlerInitLatch = new CountDownLatch(1);
        this.hints = new EnumMap(DecodeHintType.class);
        if (map != null) {
            this.hints.putAll(map);
        }
        if (enumSet == null || enumSet.isEmpty()) {
            enumSet = EnumSet.noneOf(BarcodeFormat.class);
            enumSet.addAll(DecodeFormatManager.ONE_D_FORMATS);
        }
        this.hints.put(DecodeHintType.POSSIBLE_FORMATS, enumSet);
        if (string != null) {
            this.hints.put(DecodeHintType.CHARACTER_SET, string);
        }
        Log.i((String)"DecodeThread", (String)("Hints: " + this.hints));
    }

    Handler getHandler() {
        try {
            this.handlerInitLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.handler;
    }

    public void run() {
        Looper.prepare();
        this.handler = new DecodeHandler(this.activity, this.hints);
        this.handlerInitLatch.countDown();
        Looper.loop();
    }
}

