/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned.rss;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Result;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.ResultPointCallback;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.rss.AbstractRSSReader;
import oz.util.barcode.oned.rss.DataCharacter;
import oz.util.barcode.oned.rss.FinderPattern;
import oz.util.barcode.oned.rss.Pair;
import oz.util.barcode.oned.rss.RSSUtils;

public final class RSS14Reader
extends AbstractRSSReader {
    private static final int[] OUTSIDE_EVEN_TOTAL_SUBSET = new int[]{1, 10, 34, 70, 126};
    private static final int[] INSIDE_ODD_TOTAL_SUBSET = new int[]{4, 20, 48, 81};
    private static final int[] OUTSIDE_GSUM;
    private static final int[] INSIDE_GSUM;
    private static final int[] OUTSIDE_ODD_WIDEST;
    private static final int[] INSIDE_ODD_WIDEST;
    private static final int[][] FINDER_PATTERNS;
    private final List possibleLeftPairs = new ArrayList();
    private final List possibleRightPairs = new ArrayList();

    static {
        int[] nArray = new int[5];
        nArray[1] = 161;
        nArray[2] = 961;
        nArray[3] = 2015;
        nArray[4] = 2715;
        OUTSIDE_GSUM = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 336;
        nArray2[2] = 1036;
        nArray2[3] = 1516;
        INSIDE_GSUM = nArray2;
        OUTSIDE_ODD_WIDEST = new int[]{8, 6, 4, 3, 1};
        INSIDE_ODD_WIDEST = new int[]{2, 4, 6, 8};
        FINDER_PATTERNS = new int[][]{{3, 8, 2, 1}, {3, 5, 5, 1}, {3, 3, 7, 1}, {3, 1, 9, 1}, {2, 7, 4, 1}, {2, 5, 6, 1}, {2, 3, 8, 1}, {1, 5, 7, 1}, {1, 3, 9, 1}};
    }

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map map) {
        Pair pair = this.decodePair(bitArray, false, n, map);
        RSS14Reader.addOrTally(this.possibleLeftPairs, pair);
        bitArray.reverse();
        Pair pair2 = this.decodePair(bitArray, true, n, map);
        RSS14Reader.addOrTally(this.possibleRightPairs, pair2);
        bitArray.reverse();
        int n2 = this.possibleLeftPairs.size();
        int n3 = 0;
        while (n3 < n2) {
            Pair pair3 = (Pair)this.possibleLeftPairs.get(n3);
            if (pair3.getCount() > 1) {
                int n4 = this.possibleRightPairs.size();
                int n5 = 0;
                while (n5 < n4) {
                    Pair pair4 = (Pair)this.possibleRightPairs.get(n5);
                    if (pair4.getCount() > 1 && RSS14Reader.checkChecksum(pair3, pair4)) {
                        return RSS14Reader.constructResult(pair3, pair4);
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static void addOrTally(Collection collection, Pair pair) {
        if (pair == null) {
            return;
        }
        boolean bl = false;
        for (Pair pair2 : collection) {
            if (pair2.getValue() != pair.getValue()) continue;
            pair2.incrementCount();
            bl = true;
            break;
        }
        if (!bl) {
            collection.add(pair);
        }
    }

    @Override
    public void reset() {
        this.possibleLeftPairs.clear();
        this.possibleRightPairs.clear();
    }

    private static Result constructResult(Pair pair, Pair pair2) {
        long l = 4537077L * (long)pair.getValue() + (long)pair2.getValue();
        String string = String.valueOf(l);
        StringBuilder stringBuilder = new StringBuilder(14);
        int n = 13 - string.length();
        while (n > 0) {
            stringBuilder.append('0');
            --n;
        }
        stringBuilder.append(string);
        n = 0;
        int n2 = 0;
        while (n2 < 13) {
            int n3 = stringBuilder.charAt(n2) - 48;
            n += (n2 & 1) == 0 ? 3 * n3 : n3;
            ++n2;
        }
        if ((n = 10 - n % 10) == 10) {
            n = 0;
        }
        stringBuilder.append(n);
        ResultPoint[] resultPointArray = pair.getFinderPattern().getResultPoints();
        ResultPoint[] resultPointArray2 = pair2.getFinderPattern().getResultPoints();
        return new Result(String.valueOf(stringBuilder.toString()), null, new ResultPoint[]{resultPointArray[0], resultPointArray[1], resultPointArray2[0], resultPointArray2[1]}, BarcodeFormat.RSS_14);
    }

    private static boolean checkChecksum(Pair pair, Pair pair2) {
        int n = (pair.getChecksumPortion() + 16 * pair2.getChecksumPortion()) % 79;
        int n2 = 9 * pair.getFinderPattern().getValue() + pair2.getFinderPattern().getValue();
        if (n2 > 72) {
            --n2;
        }
        if (n2 > 8) {
            --n2;
        }
        return n == n2;
    }

    private Pair decodePair(BitArray bitArray, boolean bl, int n, Map map) {
        try {
            ResultPointCallback resultPointCallback;
            int[] nArray = this.findFinderPattern(bitArray, 0, bl);
            FinderPattern finderPattern = this.parseFoundFinderPattern(bitArray, n, bl, nArray);
            ResultPointCallback resultPointCallback2 = resultPointCallback = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
            if (resultPointCallback != null) {
                float f2 = (float)(nArray[0] + nArray[1]) / 2.0f;
                if (bl) {
                    f2 = (float)(bitArray.getSize() - 1) - f2;
                }
                resultPointCallback.foundPossibleResultPoint(new ResultPoint(f2, n));
            }
            DataCharacter dataCharacter = this.decodeDataCharacter(bitArray, finderPattern, true);
            DataCharacter dataCharacter2 = this.decodeDataCharacter(bitArray, finderPattern, false);
            return new Pair(1597 * dataCharacter.getValue() + dataCharacter2.getValue(), dataCharacter.getChecksumPortion() + 4 * dataCharacter2.getChecksumPortion(), finderPattern);
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
    }

    private DataCharacter decodeDataCharacter(BitArray bitArray, FinderPattern finderPattern, boolean bl) {
        int n;
        int n2;
        int n3;
        int[] nArray = this.getDataCharacterCounters();
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[6] = 0;
        nArray[7] = 0;
        if (bl) {
            RSS14Reader.recordPatternInReverse(bitArray, finderPattern.getStartEnd()[0], nArray);
        } else {
            RSS14Reader.recordPattern(bitArray, finderPattern.getStartEnd()[1] + 1, nArray);
            n3 = 0;
            int n4 = nArray.length - 1;
            while (n3 < n4) {
                int n5 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n5;
                ++n3;
                --n4;
            }
        }
        n3 = bl ? 16 : 15;
        float f2 = (float)RSS14Reader.count(nArray) / (float)n3;
        int[] nArray2 = this.getOddCounts();
        int[] nArray3 = this.getEvenCounts();
        float[] fArray = this.getOddRoundingErrors();
        float[] fArray2 = this.getEvenRoundingErrors();
        int n6 = 0;
        while (n6 < nArray.length) {
            float f3 = (float)nArray[n6] / f2;
            n2 = (int)(f3 + 0.5f);
            if (n2 < 1) {
                n2 = 1;
            } else if (n2 > 8) {
                n2 = 8;
            }
            n = n6 >> 1;
            if ((n6 & 1) == 0) {
                nArray2[n] = n2;
                fArray[n] = f3 - (float)n2;
            } else {
                nArray3[n] = n2;
                fArray2[n] = f3 - (float)n2;
            }
            ++n6;
        }
        this.adjustOddEvenCounts(bl, n3);
        n6 = 0;
        int n7 = 0;
        n2 = nArray2.length - 1;
        while (n2 >= 0) {
            n7 *= 9;
            n7 += nArray2[n2];
            n6 += nArray2[n2];
            --n2;
        }
        n2 = 0;
        n = 0;
        int n8 = nArray3.length - 1;
        while (n8 >= 0) {
            n2 *= 9;
            n2 += nArray3[n8];
            n += nArray3[n8];
            --n8;
        }
        n8 = n7 + 3 * n2;
        if (bl) {
            if ((n6 & 1) != 0 || n6 > 12 || n6 < 4) {
                throw NotFoundException.getNotFoundInstance();
            }
            int n9 = (12 - n6) / 2;
            int n10 = OUTSIDE_ODD_WIDEST[n9];
            int n11 = 9 - n10;
            int n12 = RSSUtils.getRSSvalue(nArray2, n10, false);
            int n13 = RSSUtils.getRSSvalue(nArray3, n11, true);
            int n14 = OUTSIDE_EVEN_TOTAL_SUBSET[n9];
            int n15 = OUTSIDE_GSUM[n9];
            return new DataCharacter(n12 * n14 + n13 + n15, n8);
        }
        if ((n & 1) != 0 || n > 10 || n < 4) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n16 = (10 - n) / 2;
        int n17 = INSIDE_ODD_WIDEST[n16];
        int n18 = 9 - n17;
        int n19 = RSSUtils.getRSSvalue(nArray2, n17, true);
        int n20 = RSSUtils.getRSSvalue(nArray3, n18, false);
        int n21 = INSIDE_ODD_TOTAL_SUBSET[n16];
        int n22 = INSIDE_GSUM[n16];
        return new DataCharacter(n20 * n21 + n19 + n22, n8);
    }

    private int[] findFinderPattern(BitArray bitArray, int n, boolean bl) {
        int[] nArray = this.getDecodeFinderCounters();
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        int n2 = bitArray.getSize();
        boolean bl2 = false;
        while (n < n2) {
            boolean bl3 = bl2 = !bitArray.get(n);
            if (bl == bl2) break;
            ++n;
        }
        int n3 = 0;
        int n4 = n;
        int n5 = n;
        while (n5 < n2) {
            if (bitArray.get(n5) ^ bl2) {
                int n6 = n3;
                nArray[n6] = nArray[n6] + 1;
            } else {
                if (n3 == 3) {
                    if (RSS14Reader.isFinderPattern(nArray)) {
                        return new int[]{n4, n5};
                    }
                    n4 += nArray[0] + nArray[1];
                    nArray[0] = nArray[2];
                    nArray[1] = nArray[3];
                    nArray[2] = 0;
                    nArray[3] = 0;
                    --n3;
                } else {
                    ++n3;
                }
                nArray[n3] = 1;
                bl2 = !bl2;
            }
            ++n5;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private FinderPattern parseFoundFinderPattern(BitArray bitArray, int n, boolean bl, int[] nArray) {
        boolean bl2 = bitArray.get(nArray[0]);
        int n2 = nArray[0] - 1;
        while (n2 >= 0 && bl2 ^ bitArray.get(n2)) {
            --n2;
        }
        int n3 = nArray[0] - ++n2;
        int[] nArray2 = this.getDecodeFinderCounters();
        System.arraycopy(nArray2, 0, nArray2, 1, nArray2.length - 1);
        nArray2[0] = n3;
        int n4 = RSS14Reader.parseFinderValue(nArray2, FINDER_PATTERNS);
        int n5 = n2;
        int n6 = nArray[1];
        if (bl) {
            n5 = bitArray.getSize() - 1 - n5;
            n6 = bitArray.getSize() - 1 - n6;
        }
        return new FinderPattern(n4, new int[]{n2, nArray[1]}, n5, n6, n);
    }

    private void adjustOddEvenCounts(boolean bl, int n) {
        int n2 = RSS14Reader.count(this.getOddCounts());
        int n3 = RSS14Reader.count(this.getEvenCounts());
        int n4 = n2 + n3 - n;
        boolean bl2 = (n2 & 1) == (bl ? 1 : 0);
        boolean bl3 = (n3 & 1) == 1;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (bl) {
            if (n2 > 12) {
                bl5 = true;
            } else if (n2 < 4) {
                bl4 = true;
            }
            if (n3 > 12) {
                bl7 = true;
            } else if (n3 < 4) {
                bl6 = true;
            }
        } else {
            if (n2 > 11) {
                bl5 = true;
            } else if (n2 < 5) {
                bl4 = true;
            }
            if (n3 > 10) {
                bl7 = true;
            } else if (n3 < 4) {
                bl6 = true;
            }
        }
        if (n4 == 1) {
            if (bl2) {
                if (bl3) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl5 = true;
            } else {
                if (!bl3) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl7 = true;
            }
        } else if (n4 == -1) {
            if (bl2) {
                if (bl3) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl4 = true;
            } else {
                if (!bl3) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl6 = true;
            }
        } else if (n4 == 0) {
            if (bl2) {
                if (!bl3) {
                    throw NotFoundException.getNotFoundInstance();
                }
                if (n2 < n3) {
                    bl4 = true;
                    bl7 = true;
                } else {
                    bl5 = true;
                    bl6 = true;
                }
            } else if (bl3) {
                throw NotFoundException.getNotFoundInstance();
            }
        } else {
            throw NotFoundException.getNotFoundInstance();
        }
        if (bl4) {
            if (bl5) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSS14Reader.increment(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (bl5) {
            RSS14Reader.decrement(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (bl6) {
            if (bl7) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSS14Reader.increment(this.getEvenCounts(), this.getOddRoundingErrors());
        }
        if (bl7) {
            RSS14Reader.decrement(this.getEvenCounts(), this.getEvenRoundingErrors());
        }
    }
}

