/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned.rss.expanded.decoders;

import oz.util.barcode.NotFoundException;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.rss.expanded.decoders.AI01weightDecoder;

final class AI013x0x1xDecoder
extends AI01weightDecoder {
    private static final int HEADER_SIZE = 8;
    private static final int WEIGHT_SIZE = 20;
    private static final int DATE_SIZE = 16;
    private final String dateCode;
    private final String firstAIdigits;

    AI013x0x1xDecoder(BitArray bitArray, String string, String string2) {
        super(bitArray);
        this.dateCode = string2;
        this.firstAIdigits = string;
    }

    @Override
    public String parseInformation() {
        if (this.getInformation().getSize() != 84) {
            throw NotFoundException.getNotFoundInstance();
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.encodeCompressedGtin(stringBuilder, 8);
        this.encodeCompressedWeight(stringBuilder, 48, 20);
        this.encodeCompressedDate(stringBuilder, 68);
        return stringBuilder.toString();
    }

    private void encodeCompressedDate(StringBuilder stringBuilder, int n) {
        int n2 = this.getGeneralDecoder().extractNumericValueFromBitArray(n, 16);
        if (n2 == 38400) {
            return;
        }
        stringBuilder.append('(');
        stringBuilder.append(this.dateCode);
        stringBuilder.append(')');
        int n3 = n2 % 32;
        int n4 = (n2 /= 32) % 12 + 1;
        int n5 = n2 /= 12;
        if (n5 / 10 == 0) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n5);
        if (n4 / 10 == 0) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n4);
        if (n3 / 10 == 0) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
    }

    @Override
    protected void addWeightCode(StringBuilder stringBuilder, int n) {
        int n2 = n / 100000;
        stringBuilder.append('(');
        stringBuilder.append(this.firstAIdigits);
        stringBuilder.append(n2);
        stringBuilder.append(')');
    }

    @Override
    protected int checkWeight(int n) {
        return n % 100000;
    }
}

