/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.edit;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import oz.viewer.ui.edit.AEditableBaseView;
import oz.viewer.ui.edit.AEditableChildView;
import oz.viewer.ui.edit.AEditableUtil;

public class AEditableImageButton
extends ImageButton
implements AEditableChildView {
    private AEditableBaseView mBaseView;
    private String mURL;
    private String mRealURL;

    AEditableImageButton(Context context, AEditableBaseView aEditableBaseView) {
        super(context);
        this.setBaseView(aEditableBaseView);
    }

    AEditableImageButton(Context context, String string, int n) {
        super(context);
        this.init(string, n);
    }

    AEditableImageButton(Context context, String string, int n, AEditableBaseView aEditableBaseView) {
        super(context);
        this.setBaseView(aEditableBaseView);
        this.init(string, n);
    }

    protected void init(String string, int n) {
        this.init_Background();
        this.init_Image(string);
        this.init_Padding();
        this.init_Layout(n);
    }

    protected void init_Image(String string) {
        this.setImageURL(string);
        this.setImageDrawable();
    }

    protected void init_Padding() {
        this.setPadding(0, 0, 0, 0);
    }

    protected void init_Background() {
        this.setBackgroundColor(0);
    }

    protected void init_Layout(int n) {
        this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n));
    }

    private void setBaseView(AEditableBaseView aEditableBaseView) {
        this.mBaseView = aEditableBaseView;
    }

    public AEditableBaseView getBaseView() {
        return this.mBaseView;
    }

    public void setImageURL(String string) {
        this.mURL = string;
    }

    public String getImageURL() {
        return this.mURL;
    }

    protected void setRealImageURL(String string) {
        this.mRealURL = string;
    }

    public String getRealImageURL() {
        return this.mRealURL;
    }

    public void setImageDrawable() {
        boolean bl = true;
        String string = this.getImageURL();
        Drawable drawable2 = null;
        if (this.getRealImageURL() == null || !this.getRealImageURL().equals(string)) {
            if (string == null && this.getRealImageURL() == null) {
                bl = false;
            } else {
                drawable2 = AEditableUtil.getOZDrawableFromAssetPath(this.getContext(), string);
            }
        } else {
            bl = false;
        }
        if (bl) {
            this.setRealImageURL(string);
            this.setImageDrawable(drawable2);
        }
    }
}

