/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oz.viewer.ui.main.overlay.AButtonInfo;
import oz.viewer.ui.main.overlay.ACommentButtonInfo;
import oz.viewer.ui.main.overlay.AParameterButtonInfo;
import oz.viewer.ui.main.overlay.AToolbarButtonInfo;
import oz.viewer.ui.main.overlay.OverlayLayout;
import oz.viewer.ui.main.overlay.ToolbarManagerBase;

public class AToolbarManager
extends ToolbarManagerBase {
    public static final int BUTTON_TYPE_COMMENT = 0;
    public static final int BUTTON_TYPE_PARAMETER = 1;
    public static final int BUTTON_TYPE_ICON = 2;
    public static final int BUTTON_TYPE_COUNT = 3;

    public AToolbarManager(OverlayLayout overlayLayout) {
        super(overlayLayout, 1, 3);
    }

    protected void preInitView() {
        for (int j = 5000; j <= 5001; ++j) {
            this.addButton(0, new ACommentButtonInfo(this, j, j));
        }
        this.getButtonFromKey(0, 5001).setVisibility(8);
        this.addButton(1, new AParameterButtonInfo(this));
        this.setButtonTypeVisibility(0, false);
        this.setButtonTypeVisibility(1, false);
    }

    protected void addToOverlayView(OverlayLayout overlayLayout, View view) {
        FrameLayout frameLayout = (FrameLayout)overlayLayout.findLayout(21110);
        frameLayout.addView(view, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
    }

    public void requestUpdateView() {
        super.requestUpdateView();
        if (!this.getOZParent().getScreenToolController().isCommentMode()) {
            this.getOZParent().getNavigator().requestUpdateView();
        }
    }

    public void show() {
        super.show();
        if (!this.getOZParent().getScreenToolController().isCommentMode()) {
            this.getOZParent().getNavigator().show();
        }
    }

    public AButtonInfo[] getButtons(int n) {
        if (n == 2) {
            AButtonInfo[] aButtonInfoArray = new AButtonInfo[this.getButtonCount(n)];
            ((Map)this.getButtonInfos().get(n)).values().toArray(aButtonInfoArray);
            List<AButtonInfo> list = Arrays.asList(aButtonInfoArray);
            Collections.sort(list);
            return list.toArray(aButtonInfoArray);
        }
        return super.getButtons(n);
    }

    public void addToolbarButton(int n, int n2) {
        if (n == -1) {
            return;
        }
        this.addButton(2, new AToolbarButtonInfo(this, n, n2, ((Map)this.getButtonInfos().get(2)).size()));
    }

    public boolean isAutoHideEnable() {
        if (this.getOZParent().getScreenToolController().isHandMode()) {
            return super.isAutoHideEnable();
        }
        return this.getOZParent().getCommentManager().isAutoHideEnable();
    }
}

