/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.android.sdaiflib;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.nttdocomo.android.sdaiflib.ReceiveSensorData;
import com.nttdocomo.android.sdaiflib.SendBase;
import com.nttdocomo.android.sdaiflib.Utils;

public class ControlSensorData
extends SendBase {
    private static final String ExtraNameTag = "com.nttdocomo.android.smartdeviceagent.extra";
    private static final String Tag = "SDALib_SensorData";
    private Context mContext;
    private Activity mActivity;
    private ReceiveSensorData mReceiver;
    private String mBDaddress = null;
    private int mType = -1;
    private int mInterval = 86400000;
    private int mDuration = -1;
    private float mThresholdX = 0.0f;
    private float mThresholdY = 0.0f;
    private float mThresholdZ = 0.0f;
    private byte[] mOriginalData = null;

    public ControlSensorData() {
        this.mContext = null;
        this.mActivity = null;
    }

    public ControlSensorData(Activity activity, SensorDataInterface observer) {
        this.mContext = activity.getApplicationContext();
        this.mActivity = activity;
        IntentFilter filter = null;
        filter = new IntentFilter();
        filter.addAction("com.nttdocomo.android.smartdeviceagent.action.SENSOR_DATA");
        filter.addAction("com.nttdocomo.android.smartdeviceagent.action.STOP_SENSOR");
        filter.addAction("com.nttdocomo.android.smartdeviceagent.action.PAUSE_SENSOR");
        filter.addAction("com.nttdocomo.android.smartdeviceagent.action.RESUME_SENSOR");
        this.mReceiver = new ReceiveSensorData(observer);
        this.mContext.registerReceiver((BroadcastReceiver)this.mReceiver, filter);
    }

    public ControlSensorData(Context context, SensorRequestInterface requestObserver, SensorDataInterface dataObserver) {
        this.mContext = context.getApplicationContext();
        this.mActivity = null;
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.nttdocomo.android.smartdeviceagent.action.SENSOR_DATA");
        filter.addAction("com.nttdocomo.android.smartdeviceagent.action.STOP_SENSOR");
        filter.addAction("com.nttdocomo.android.smartdeviceagent.action.PAUSE_SENSOR");
        filter.addAction("com.nttdocomo.android.smartdeviceagent.action.RESUME_SENSOR");
        filter.addAction("com.nttdocomo.android.smartdeviceagent.action.START_SENSOR_RESULT");
        this.mReceiver = new ReceiveSensorData(requestObserver, dataObserver);
        this.mContext.registerReceiver((BroadcastReceiver)this.mReceiver, filter);
    }

    public boolean setBDaddress(String address) {
        if (address == null || address.equals("")) {
            return false;
        }
        this.mBDaddress = address;
        return true;
    }

    public boolean setType(int type) {
        this.mType = type;
        return true;
    }

    public boolean setInterval(int interval) {
        this.mInterval = interval;
        return true;
    }

    public boolean setDuration(int duration) {
        this.mDuration = duration;
        return true;
    }

    public boolean setThreshold(float x, float y, float z) {
        this.mThresholdX = x;
        this.mThresholdY = y;
        this.mThresholdZ = z;
        return true;
    }

    public boolean setOriginalData(byte[] originalData) {
        this.mOriginalData = originalData;
        return true;
    }

    public int onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode != 4) {
            return 9;
        }
        return resultCode;
    }

    public int start() {
        return this.updateContent(true);
    }

    public int stop() {
        return this.updateContent(false);
    }

    public void release() {
        if (this.mContext != null && this.mReceiver != null) {
            try {
                this.mContext.unregisterReceiver((BroadcastReceiver)this.mReceiver);
                this.mReceiver = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private int updateContent(boolean mode) {
        if (this.mContext == null) {
            return 1025;
        }
        if (this.mBDaddress == null) {
            return 5;
        }
        if (mode) {
            if (this.mActivity != null) {
                Intent intent = new Intent("com.nttdocomo.android.smartdeviceagent.action.START_SENSOR");
                intent.setComponent(new ComponentName("com.nttdocomo.android.smartdeviceagent", "com.nttdocomo.android.smartdeviceagent.RequestStartActivity"));
                this.putStartExtra(ExtraNameTag, intent);
                try {
                    this.mActivity.startActivityForResult(intent, 4);
                }
                catch (ActivityNotFoundException e) {
                    return 518;
                }
            } else {
                if (!Utils.checkSdaVersion(this.mContext, 152)) {
                    return 1027;
                }
                Intent intent = new Intent(this.mContext.getPackageName() + ".sda.action.START_SENSOR");
                intent.setComponent(new ComponentName("com.nttdocomo.android.smartdeviceagent", "com.nttdocomo.android.smartdeviceagent.RequestReceiver"));
                this.putStartExtra(this.mContext.getPackageName() + ".sda.extra", intent);
                this.mContext.sendBroadcast(intent);
            }
        } else {
            Intent intent = new Intent(this.mContext.getPackageName() + ".sda.action.STOP_SENSOR");
            intent.setComponent(new ComponentName("com.nttdocomo.android.smartdeviceagent", "com.nttdocomo.android.smartdeviceagent.RequestReceiver"));
            intent.putExtra(this.mContext.getPackageName() + ".sda.extra.BD_ADDRESS", this.mBDaddress);
            this.mContext.sendBroadcast(intent);
        }
        return -1;
    }

    private void putStartExtra(String extraNameTag, Intent intent) {
        intent.putExtra(extraNameTag + ".BD_ADDRESS", this.mBDaddress);
        intent.putExtra(extraNameTag + ".SENSOR_TYPE", this.mType);
        intent.putExtra(extraNameTag + ".SENSOR_INTERVAL", this.mInterval);
        intent.putExtra(extraNameTag + ".SENSOR_DURATION", this.mDuration);
        intent.putExtra(extraNameTag + ".X_THRESHOLD", this.mThresholdX);
        intent.putExtra(extraNameTag + ".Y_THRESHOLD", this.mThresholdY);
        intent.putExtra(extraNameTag + ".Z_THRESHOLD", this.mThresholdZ);
        if (this.mOriginalData != null) {
            intent.putExtra(extraNameTag + ".CONTENT_SENSOR_DATA", this.mOriginalData);
        }
    }

    public static interface SensorDataInterface {
        public void onStopSensor(String var1, int var2, int var3);

        public void onSensorData(String var1, int var2, float var3, float var4, float var5, byte[] var6, long var7);

        public void onPauseSensor(String var1, int var2);

        public void onResumeSensor(String var1, int var2);
    }

    public static interface SensorRequestInterface {
        public void onStartSensorResult(String var1, int var2, int var3);
    }
}

