/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.android.sdaiflib;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.nttdocomo.android.sdaiflib.SendBase;
import com.nttdocomo.android.sdaiflib.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class GetActivities
extends SendBase {
    private static final String ACTIVITIES_URI = "content://com.nttdocomo.android.smartdeviceagent/activities";
    private static final String Tag = "SDALib_GetActivities";
    private Context mContext;
    private int mKey = -1;
    private int mCount = -1;
    private String mUri = null;

    public GetActivities() {
        this.mContext = null;
    }

    public GetActivities(Context context) {
        this.mContext = context;
    }

    public boolean setKey(int key) {
        this.mKey = key;
        return true;
    }

    public int getData(String startTime) {
        if (this.mKey == -1 && !this.deviceID_flag && !this.deviceUID_flag) {
            return 1026;
        }
        String str = "content://com.nttdocomo.android.smartdeviceagent/activities/" + String.valueOf(this.mKey) + "/" + String.valueOf(this.mDeviceID) + "/" + String.valueOf(this.mDeviceUIDInt) + "/" + Utils.getTimeLong(startTime);
        ContentResolver resolver = this.mContext.getContentResolver();
        Cursor cursor = null;
        try {
            cursor = resolver.query(Uri.parse((String)str), null, null, null, null);
        }
        catch (SecurityException e) {
            return 514;
        }
        catch (IllegalStateException e) {
            return 515;
        }
        if (cursor == null || !cursor.moveToFirst()) {
            return 517;
        }
        this.mCount = cursor.getInt(cursor.getColumnIndex("count"));
        this.mUri = cursor.getString(cursor.getColumnIndex("content_uri"));
        Log.d((String)Tag, (String)("\u53d6\u5f97\u4ef6\u6570\uff1a" + String.valueOf(this.mCount) + "\u4ef6"));
        return -1;
    }

    public int getCount() {
        return this.mCount;
    }

    public String getUri() {
        return this.mUri;
    }

    public String getInformation(String fileroot, String filename) {
        File root = new File(fileroot);
        root.mkdirs();
        File file = new File(root, filename);
        if (file.exists()) {
            file.delete();
        }
        try {
            Uri uri = Uri.parse((String)this.mUri);
            InputStream is = this.mContext.getContentResolver().openInputStream(uri);
            FileOutputStream fos = new FileOutputStream(file, true);
            int available = is.available();
            while (available > 0) {
                byte[] buffer = new byte[available];
                int rsize = is.read(buffer, 0, available);
                fos.write(buffer, 0, rsize);
                available = is.available();
            }
            is.close();
            fos.close();
        }
        catch (IOException e) {
            file.delete();
            return null;
        }
        return file.getAbsolutePath();
    }
}

