/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.android.sdaiflib;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.nttdocomo.android.sdaiflib.ControlSensorData;

public class ReceiveSensorData
extends BroadcastReceiver {
    private static final String TAG = "Receiver";
    private ControlSensorData.SensorRequestInterface mRequestObserver;
    private ControlSensorData.SensorDataInterface mDataObserver;

    public ReceiveSensorData(ControlSensorData.SensorRequestInterface requestObserver, ControlSensorData.SensorDataInterface dataObserver) {
        this.mRequestObserver = requestObserver;
        this.mDataObserver = dataObserver;
    }

    public ReceiveSensorData(ControlSensorData.SensorDataInterface observer) {
        this.mRequestObserver = null;
        this.mDataObserver = observer;
    }

    public ReceiveSensorData() {
        this.mRequestObserver = null;
        this.mDataObserver = null;
    }

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action == null) {
            return;
        }
        if (this.mDataObserver != null) {
            if ("com.nttdocomo.android.smartdeviceagent.action.SENSOR_DATA".equals(action)) {
                String address = intent.getStringExtra("com.nttdocomo.android.smartdeviceagent.extra.BD_ADDRESS");
                int type = intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.SENSOR_TYPE", -1);
                float x = intent.getFloatExtra("com.nttdocomo.android.smartdeviceagent.extra.SENSOR_X", 0.0f);
                float y = intent.getFloatExtra("com.nttdocomo.android.smartdeviceagent.extra.SENSOR_Y", 0.0f);
                float z = intent.getFloatExtra("com.nttdocomo.android.smartdeviceagent.extra.SENSOR_Z", 0.0f);
                byte[] data = intent.getByteArrayExtra("com.nttdocomo.android.smartdeviceagent.extra.CONTENT_SENSOR_DATA");
                long time = intent.getLongExtra("com.nttdocomo.android.smartdeviceagent.extra.SENSOR_GET_TIME", -1L);
                this.mDataObserver.onSensorData(address, type, x, y, z, data, time);
                return;
            }
            if ("com.nttdocomo.android.smartdeviceagent.action.STOP_SENSOR".equals(action)) {
                String address = intent.getStringExtra("com.nttdocomo.android.smartdeviceagent.extra.BD_ADDRESS");
                int type = intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.SENSOR_TYPE", -1);
                int reason = intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.SENSOR_REASON", -1);
                this.mDataObserver.onStopSensor(address, type, reason);
                return;
            }
            if ("com.nttdocomo.android.smartdeviceagent.action.PAUSE_SENSOR".equals(action)) {
                String address = intent.getStringExtra("com.nttdocomo.android.smartdeviceagent.extra.BD_ADDRESS");
                int type = intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.SENSOR_TYPE", -1);
                this.mDataObserver.onPauseSensor(address, type);
                return;
            }
            if ("com.nttdocomo.android.smartdeviceagent.action.RESUME_SENSOR".equals(action)) {
                String address = intent.getStringExtra("com.nttdocomo.android.smartdeviceagent.extra.BD_ADDRESS");
                int type = intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.SENSOR_TYPE", -1);
                this.mDataObserver.onResumeSensor(address, type);
                return;
            }
        }
        if (this.mRequestObserver != null && "com.nttdocomo.android.smartdeviceagent.action.START_SENSOR_RESULT".equals(action)) {
            String address = intent.getStringExtra("com.nttdocomo.android.smartdeviceagent.extra.BD_ADDRESS");
            int type = intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.SENSOR_TYPE", -1);
            int result = intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.RESULT", -1);
            this.mRequestObserver.onStartSensorResult(address, type, result);
            return;
        }
    }
}

