/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.android.sdaiflib;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import com.nttdocomo.android.sdaiflib.NotifyConnect;
import com.nttdocomo.android.sdaiflib.Utils;

public class ReceiverConnect
extends BroadcastReceiver {
    private static final String TAG = "Receiver_connect";
    private NotifyConnect.ConnectInterface mObserver = null;

    public ReceiverConnect(NotifyConnect.ConnectInterface observer) {
        this.mObserver = observer;
        if (observer == null) {
            Log.d((String)TAG, (String)"observer null");
        }
    }

    public ReceiverConnect() {
        this.mObserver = null;
    }

    public void onReceive(Context context, Intent intent) {
        String action;
        Log.d((String)TAG, (String)intent.toString());
        Bundle extra = intent.getExtras();
        if (extra != null) {
            Log.d((String)TAG, (String)intent.getExtras().toString());
        }
        if ((action = intent.getAction()) == null) {
            return;
        }
        if (this.mObserver == null) {
            Log.d((String)TAG, (String)"ERROR:observer null");
        }
        if ("com.nttdocomo.android.smartdeviceagent.action.CONNECTED".equals(action)) {
            SharedPreferences preference = context.getSharedPreferences("DeviceConnectInformation", 0);
            SharedPreferences.Editor editor = preference.edit();
            editor.putLong("RECEIVE_TIME", Utils.getCurrentTimeLong());
            editor.putString("DEVICE_NAME", intent.getStringExtra("com.nttdocomo.android.smartdeviceagent.extra.DEVICE_NAME"));
            editor.putInt("DEVICE_ID", intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.DEVICE_ID", -1));
            editor.putInt("DEVICE_UID", intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.DEVICE_UID", -1));
            editor.putString("BD_ADDRESS", intent.getStringExtra("com.nttdocomo.android.smartdeviceagent.extra.BD_ADDRESS"));
            editor.putInt("CAPABILITY", intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.CAPABILITY", -1));
            editor.putInt("EX_SENSOR_TYPE", intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.EX_SENSOR_TYPE", -1));
            editor.commit();
            if (this.mObserver != null) {
                this.mObserver.onConnect();
            }
        } else if ("com.nttdocomo.android.smartdeviceagent.action.DISCONNECTED".equals(action)) {
            SharedPreferences preference = context.getSharedPreferences("DeviceDisconnectInformation", 0);
            SharedPreferences.Editor editor = preference.edit();
            editor.putLong("RECEIVE_TIME", Utils.getCurrentTimeLong());
            editor.putString("DEVICE_NAME", intent.getStringExtra("com.nttdocomo.android.smartdeviceagent.extra.DEVICE_NAME"));
            editor.putInt("DEVICE_ID", intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.DEVICE_ID", -1));
            editor.putInt("DEVICE_UID", intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.DEVICE_UID", -1));
            editor.commit();
            if (this.mObserver != null) {
                this.mObserver.onDisconnect();
            }
        }
    }
}

