/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.android.sdaiflib;

import android.content.Context;
import android.content.Intent;
import android.util.Log;

public class SendRinging {
    private static final String ACTION_SUFFIX = ".sda.action.RINGING";
    private static final String Tag = "SDALib_Ringing";
    public static final int RESULT_OK = 0;
    private static final int RESULT_PARAMETER_ERROR = 1025;
    private static final int RESULT_CONTEXT_NG = 1026;
    private Context mContext;
    public int mType = -1;
    public String mTelNo = null;
    public String mDispName = null;

    public SendRinging() {
        this.mContext = null;
    }

    public SendRinging(Context context) {
        this.mContext = context;
    }

    public boolean setType(int type) {
        if (type == 0 || type == 1) {
            this.mType = type;
            return true;
        }
        return false;
    }

    public boolean setTelNo(String telNo) {
        if (telNo == null || telNo.equals("")) {
            return false;
        }
        this.mTelNo = telNo;
        return true;
    }

    public boolean setDispName(String dispName) {
        if (dispName == null || dispName.equals("")) {
            return false;
        }
        this.mDispName = dispName;
        return true;
    }

    public int send(String tel) {
        if (this.setTelNo(tel)) {
            return this.send();
        }
        return 1025;
    }

    public int send() {
        if (this.mTelNo == null || this.mTelNo.equals("")) {
            return 1025;
        }
        Intent intent = new Intent("com.android.phone.sda.action.RINGING");
        intent.setClassName("com.nttdocomo.android.smartdeviceagent", "com.nttdocomo.android.smartdeviceagent.RingingReceiver");
        intent.putExtra(this.makeExtraName("PHONE_NUMBER"), this.mTelNo);
        if (this.mDispName != null && this.mDispName != "") {
            intent.putExtra(this.makeExtraName("NAME"), this.mDispName);
        }
        if (this.mType >= 0) {
            intent.putExtra(this.makeExtraName("CALL_TYPE"), this.mType);
        }
        Log.d((String)Tag, (String)intent.toString());
        if (intent.getExtras() != null) {
            Log.d((String)Tag, (String)intent.getExtras().toString());
        }
        if (this.mContext == null) {
            return 1026;
        }
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public void clear() {
        this.mType = -1;
        this.mDispName = null;
        this.mTelNo = null;
    }

    private String makeExtraName(String name) {
        return "com.android.phone.sda.extra." + name;
    }
}

