/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Trace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.PathUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.SuppressFBWarnings;

public class ResourceExtractor {
    private static final String TAG = "cr.base";
    private static final String ICU_DATA_FILENAME = "icudtl.dat";
    private static final String V8_NATIVES_DATA_FILENAME = "natives_blob.bin";
    private static final String V8_SNAPSHOT_DATA_FILENAME = "snapshot_blob.bin";
    private static final String APP_VERSION_PREF = "org.chromium.base.ResourceExtractor.Version";
    private static ResourceEntry[] sResourcesToExtract = new ResourceEntry[0];
    private static ResourceInterceptor sInterceptor = null;
    private final Context mContext;
    private ExtractTask mExtractTask;
    private static ResourceExtractor sInstance;

    private static boolean isAppDataFile(String file) {
        return ICU_DATA_FILENAME.equals(file) || V8_NATIVES_DATA_FILENAME.equals(file) || V8_SNAPSHOT_DATA_FILENAME.equals(file);
    }

    public static ResourceExtractor get(Context context) {
        if (sInstance == null) {
            sInstance = new ResourceExtractor(context);
        }
        return sInstance;
    }

    public static void setResourceInterceptor(ResourceInterceptor interceptor) {
        assert (sInstance == null || ResourceExtractor.sInstance.mExtractTask == null) : "Must be called before startExtractingResources is called";
        sInterceptor = interceptor;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_STATIC_REP2"})
    public static void setResourcesToExtract(ResourceEntry[] entries) {
        assert (sInstance == null || ResourceExtractor.sInstance.mExtractTask == null) : "Must be called before startExtractingResources is called";
        sResourcesToExtract = entries;
    }

    private ResourceExtractor(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public void waitForCompletion() {
        if (ResourceExtractor.shouldSkipPakExtraction()) {
            return;
        }
        assert (this.mExtractTask != null);
        try {
            this.mExtractTask.get();
            sInterceptor = null;
            sInstance = null;
        }
        catch (CancellationException e) {
            this.deleteFiles();
        }
        catch (ExecutionException e2) {
            this.deleteFiles();
        }
        catch (InterruptedException e3) {
            this.deleteFiles();
        }
    }

    public void addCompletionCallback(Runnable callback) {
        ThreadUtils.assertOnUiThread();
        Handler handler = new Handler(Looper.getMainLooper());
        if (ResourceExtractor.shouldSkipPakExtraction()) {
            handler.post(callback);
            return;
        }
        assert (this.mExtractTask != null);
        assert (!this.mExtractTask.isCancelled());
        if (this.mExtractTask.getStatus() == AsyncTask.Status.FINISHED) {
            handler.post(callback);
        } else {
            this.mExtractTask.mCompletionCallbacks.add(callback);
        }
    }

    public void startExtractingResources() {
        if (this.mExtractTask != null) {
            return;
        }
        if (ResourceExtractor.shouldSkipPakExtraction()) {
            return;
        }
        this.mExtractTask = new ExtractTask();
        this.mExtractTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    private File getAppDataDir() {
        return new File(PathUtils.getDataDirectory(this.mContext));
    }

    private File getOutputDir() {
        return new File(this.getAppDataDir(), "paks");
    }

    private void deleteFiles() {
        File[] files;
        File dir;
        File v8_snapshot;
        File v8_natives;
        File icudata = new File(this.getAppDataDir(), ICU_DATA_FILENAME);
        if (icudata.exists() && !icudata.delete()) {
            Log.e(TAG, "Unable to remove the icudata %s", icudata.getName());
        }
        if ((v8_natives = new File(this.getAppDataDir(), V8_NATIVES_DATA_FILENAME)).exists() && !v8_natives.delete()) {
            Log.e(TAG, "Unable to remove the v8 data %s", v8_natives.getName());
        }
        if ((v8_snapshot = new File(this.getAppDataDir(), V8_SNAPSHOT_DATA_FILENAME)).exists() && !v8_snapshot.delete()) {
            Log.e(TAG, "Unable to remove the v8 data %s", v8_snapshot.getName());
        }
        if ((dir = this.getOutputDir()).exists() && (files = dir.listFiles()) != null) {
            for (File file : files) {
                if (file.delete()) continue;
                Log.e(TAG, "Unable to remove existing resource %s", file.getName());
            }
        }
    }

    private static boolean shouldSkipPakExtraction() {
        return sResourcesToExtract.length == 0;
    }

    private class ExtractTask
    extends AsyncTask<Void, Void, Void> {
        private static final int BUFFER_SIZE = 16384;
        private final List<Runnable> mCompletionCallbacks = new ArrayList<Runnable>();

        private ExtractTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void extractResourceHelper(InputStream is, File outFile, byte[] buffer) throws IOException {
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(outFile);
                Log.i(ResourceExtractor.TAG, "Extracting resource %s", outFile);
                int count = 0;
                while ((count = is.read(buffer, 0, 16384)) != -1) {
                    ((OutputStream)os).write(buffer, 0, count);
                }
            }
            finally {
                try {
                    if (os != null) {
                        ((OutputStream)os).close();
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doInBackgroundImpl() {
            File outputDir = ResourceExtractor.this.getOutputDir();
            File appDataDir = ResourceExtractor.this.getAppDataDir();
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                Log.e(ResourceExtractor.TAG, "Unable to create pak resources directory!", new Object[0]);
                return;
            }
            this.beginTraceSection("checkPakTimeStamp");
            long curAppVersion = this.getApkVersion();
            SharedPreferences sharedPrefs = ContextUtils.getAppSharedPreferences();
            long prevAppVersion = sharedPrefs.getLong(ResourceExtractor.APP_VERSION_PREF, 0L);
            boolean versionChanged = curAppVersion != prevAppVersion;
            this.endTraceSection();
            if (versionChanged) {
                ResourceExtractor.this.deleteFiles();
                sharedPrefs.edit().putLong(ResourceExtractor.APP_VERSION_PREF, curAppVersion).apply();
            }
            this.beginTraceSection("WalkAssets");
            byte[] buffer = new byte[16384];
            try {
                for (ResourceEntry entry : sResourcesToExtract) {
                    File dir = ResourceExtractor.isAppDataFile(entry.extractedFileName) ? appDataDir : outputDir;
                    File output = new File(dir, entry.extractedFileName);
                    if (output.length() != 0L) continue;
                    this.beginTraceSection("ExtractResource");
                    InputStream inputStream = sInterceptor != null && sInterceptor.shouldInterceptLoadRequest(entry.extractedFileName) ? sInterceptor.openRawResource(entry.extractedFileName) : ResourceExtractor.this.mContext.getResources().openRawResource(entry.resourceId);
                    try {
                        this.extractResourceHelper(inputStream, output, buffer);
                    }
                    finally {
                        this.endTraceSection();
                    }
                }
            }
            catch (IOException e) {
                Log.w(ResourceExtractor.TAG, "Exception unpacking required pak resources: %s", e.getMessage());
                ResourceExtractor.this.deleteFiles();
                return;
            }
            finally {
                this.endTraceSection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void doInBackground(Void ... unused) {
            this.beginTraceSection("ResourceExtractor.ExtractTask.doInBackground");
            try {
                this.doInBackgroundImpl();
            }
            finally {
                this.endTraceSection();
            }
            return null;
        }

        private void onPostExecuteImpl() {
            for (int i = 0; i < this.mCompletionCallbacks.size(); ++i) {
                this.mCompletionCallbacks.get(i).run();
            }
            this.mCompletionCallbacks.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onPostExecute(Void result) {
            this.beginTraceSection("ResourceExtractor.ExtractTask.onPostExecute");
            try {
                this.onPostExecuteImpl();
            }
            finally {
                this.endTraceSection();
            }
        }

        private long getApkVersion() {
            PackageManager pm = ResourceExtractor.this.mContext.getPackageManager();
            try {
                PackageInfo pi = pm.getPackageInfo(ResourceExtractor.this.mContext.getPackageName(), 0);
                return pi.lastUpdateTime;
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        @TargetApi(value=18)
        private void beginTraceSection(String section) {
            if (Build.VERSION.SDK_INT < 18) {
                return;
            }
            Trace.beginSection((String)section);
        }

        @TargetApi(value=18)
        private void endTraceSection() {
            if (Build.VERSION.SDK_INT < 18) {
                return;
            }
            Trace.endSection();
        }
    }

    public static final class ResourceEntry {
        public final int resourceId;
        public final String pathWithinApk;
        public final String extractedFileName;

        public ResourceEntry(int resourceId, String pathWithinApk, String extractedFileName) {
            this.resourceId = resourceId;
            this.pathWithinApk = pathWithinApk;
            this.extractedFileName = extractedFileName;
        }
    }

    public static interface ResourceInterceptor {
        public boolean shouldInterceptLoadRequest(String var1);

        public InputStream openRawResource(String var1);
    }
}

