/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.annotation.TargetApi;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Handler;
import android.util.LruCache;
import android.util.SparseArray;
import java.util.Map;
import org.chromium.base.Log;
import org.chromium.base.SysUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.metrics.RecordHistogram;
import org.chromium.content.browser.BindingManager;
import org.chromium.content.browser.ChildProcessConnection;

class BindingManagerImpl
implements BindingManager {
    private static final String TAG = "cr.BindingManager";
    private static final float MODERATE_BINDING_LOW_REDUCE_RATIO = 0.25f;
    private static final float MODERATE_BINDING_HIGH_REDUCE_RATIO = 0.5f;
    private static final long DETACH_AS_ACTIVE_HIGH_END_DELAY_MILLIS = 1000L;
    private static final long MODERATE_BINDING_POOL_CLEARER_DELAY_MILLIS = 10000L;
    private final boolean mIsLowMemoryDevice;
    private final Object mModerateBindingPoolLock = new Object();
    private ModerateBindingPool mModerateBindingPool;
    private boolean mModerateBindingTillBackgrounded;
    private final SparseArray<ManagedConnection> mManagedConnections = new SparseArray();
    private ManagedConnection mLastInForeground;
    private final Object mLastInForegroundLock = new Object();
    private ManagedConnection mBoundForBackgroundPeriod;
    private final boolean mOnTesting;

    private BindingManagerImpl(boolean isLowMemoryDevice, boolean onTesting) {
        this.mIsLowMemoryDevice = isLowMemoryDevice;
        this.mOnTesting = onTesting;
    }

    public static BindingManagerImpl createBindingManager() {
        return new BindingManagerImpl(SysUtils.isLowEndDevice(), false);
    }

    public static BindingManagerImpl createBindingManagerForTesting(boolean isLowEndDevice) {
        return new BindingManagerImpl(isLowEndDevice, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNewConnection(int pid, ChildProcessConnection connection) {
        SparseArray<ManagedConnection> sparseArray = this.mManagedConnections;
        synchronized (sparseArray) {
            this.mManagedConnections.put(pid, (Object)new ManagedConnection(connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInForeground(int pid, boolean inForeground) {
        ManagedConnection managedConnection;
        Object object = this.mManagedConnections;
        synchronized (object) {
            managedConnection = (ManagedConnection)this.mManagedConnections.get(pid);
        }
        if (managedConnection == null) {
            Log.w(TAG, "Cannot setInForeground() - never saw a connection for the pid: %d", pid);
            return;
        }
        object = this.mLastInForegroundLock;
        synchronized (object) {
            if (inForeground && this.mIsLowMemoryDevice && this.mLastInForeground != null && this.mLastInForeground != managedConnection) {
                this.mLastInForeground.dropBindings();
            }
            managedConnection.setInForeground(inForeground);
            if (inForeground) {
                this.mLastInForeground = managedConnection;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void determinedVisibility(int pid) {
        ManagedConnection managedConnection;
        SparseArray<ManagedConnection> sparseArray = this.mManagedConnections;
        synchronized (sparseArray) {
            managedConnection = (ManagedConnection)this.mManagedConnections.get(pid);
        }
        if (managedConnection == null) {
            Log.w(TAG, "Cannot call determinedVisibility() - never saw a connection for the pid: %d", pid);
            return;
        }
        managedConnection.determinedVisibility();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSentToBackground() {
        ModerateBindingPool moderateBindingPool;
        assert (this.mBoundForBackgroundPeriod == null);
        Object object = this.mLastInForegroundLock;
        synchronized (object) {
            if (this.mLastInForeground != null) {
                this.mLastInForeground.setBoundForBackgroundPeriod(true);
                this.mBoundForBackgroundPeriod = this.mLastInForeground;
            }
        }
        Object object2 = this.mModerateBindingPoolLock;
        synchronized (object2) {
            moderateBindingPool = this.mModerateBindingPool;
        }
        if (moderateBindingPool != null) {
            moderateBindingPool.onSentToBackground(this.mOnTesting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBroughtToForeground() {
        ModerateBindingPool moderateBindingPool;
        if (this.mBoundForBackgroundPeriod != null) {
            this.mBoundForBackgroundPeriod.setBoundForBackgroundPeriod(false);
            this.mBoundForBackgroundPeriod = null;
        }
        Object object = this.mModerateBindingPoolLock;
        synchronized (object) {
            moderateBindingPool = this.mModerateBindingPool;
        }
        if (moderateBindingPool != null) {
            moderateBindingPool.onBroughtToForeground();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOomProtected(int pid) {
        ManagedConnection managedConnection;
        SparseArray<ManagedConnection> sparseArray = this.mManagedConnections;
        synchronized (sparseArray) {
            managedConnection = (ManagedConnection)this.mManagedConnections.get(pid);
        }
        return managedConnection != null ? managedConnection.isOomProtected() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearConnection(int pid) {
        ManagedConnection managedConnection;
        SparseArray<ManagedConnection> sparseArray = this.mManagedConnections;
        synchronized (sparseArray) {
            managedConnection = (ManagedConnection)this.mManagedConnections.get(pid);
        }
        if (managedConnection != null) {
            managedConnection.clearConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean isConnectionCleared(int pid) {
        SparseArray<ManagedConnection> sparseArray = this.mManagedConnections;
        synchronized (sparseArray) {
            return ((ManagedConnection)this.mManagedConnections.get(pid)).isConnectionCleared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startModerateBindingManagement(Context context, int maxSize, boolean moderateBindingTillBackgrounded) {
        Object object = this.mModerateBindingPoolLock;
        synchronized (object) {
            if (this.mIsLowMemoryDevice || this.mModerateBindingPool != null) {
                return;
            }
            this.mModerateBindingTillBackgrounded = moderateBindingTillBackgrounded;
            Log.i(TAG, "Moderate binding enabled: maxSize=%d", maxSize);
            this.mModerateBindingPool = new ModerateBindingPool(maxSize);
            if (context != null) {
                context.registerComponentCallbacks((ComponentCallbacks)this.mModerateBindingPool);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAllModerateBindings() {
        ModerateBindingPool moderateBindingPool;
        Object object = this.mModerateBindingPoolLock;
        synchronized (object) {
            moderateBindingPool = this.mModerateBindingPool;
        }
        if (moderateBindingPool != null) {
            Log.i(TAG, "Release all moderate bindings: %d", moderateBindingPool.size());
            moderateBindingPool.evictAll();
        }
    }

    private class ManagedConnection {
        private ChildProcessConnection mConnection;
        private boolean mInForeground;
        private boolean mBoundForBackgroundPeriod;
        private boolean mWasOomProtected;

        private boolean removeInitialBinding() {
            if (this.mConnection == null || !this.mConnection.isInitialBindingBound()) {
                return false;
            }
            this.mConnection.removeInitialBinding();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addStrongBinding() {
            ModerateBindingPool moderateBindingPool;
            ChildProcessConnection connection = this.mConnection;
            if (connection == null) {
                return;
            }
            connection.addStrongBinding();
            Object object = BindingManagerImpl.this.mModerateBindingPoolLock;
            synchronized (object) {
                moderateBindingPool = BindingManagerImpl.this.mModerateBindingPool;
            }
            if (moderateBindingPool != null) {
                moderateBindingPool.removeConnection(this);
            }
        }

        private void removeStrongBinding(final boolean keepAsModerate) {
            final ChildProcessConnection connection = this.mConnection;
            if (connection == null || !connection.isStrongBindingBound()) {
                return;
            }
            Runnable doUnbind = new Runnable(){

                @Override
                public void run() {
                    if (connection.isStrongBindingBound()) {
                        connection.removeStrongBinding();
                        if (keepAsModerate) {
                            ManagedConnection.this.addConnectionToModerateBindingPool(connection);
                        }
                    }
                }
            };
            if (BindingManagerImpl.this.mIsLowMemoryDevice) {
                doUnbind.run();
            } else {
                ThreadUtils.postOnUiThreadDelayed(doUnbind, 1000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addConnectionToModerateBindingPool(ChildProcessConnection connection) {
            ModerateBindingPool moderateBindingPool;
            Object object = BindingManagerImpl.this.mModerateBindingPoolLock;
            synchronized (object) {
                moderateBindingPool = BindingManagerImpl.this.mModerateBindingPool;
            }
            if (moderateBindingPool != null && !connection.isStrongBindingBound()) {
                moderateBindingPool.addConnection(this);
            }
        }

        private void removeModerateBinding() {
            if (this.mConnection == null || !this.mConnection.isModerateBindingBound()) {
                return;
            }
            this.mConnection.removeModerateBinding();
        }

        private void addModerateBinding() {
            ChildProcessConnection connection = this.mConnection;
            if (connection == null) {
                return;
            }
            connection.addModerateBinding();
        }

        private void dropBindings() {
            assert (BindingManagerImpl.this.mIsLowMemoryDevice);
            ChildProcessConnection connection = this.mConnection;
            if (connection == null) {
                return;
            }
            connection.dropOomBindings();
        }

        ManagedConnection(ChildProcessConnection connection) {
            this.mConnection = connection;
        }

        void setInForeground(boolean nextInForeground) {
            if (!this.mInForeground && nextInForeground) {
                this.addStrongBinding();
            } else if (this.mInForeground && !nextInForeground) {
                this.removeStrongBinding(true);
            }
            this.mInForeground = nextInForeground;
        }

        void determinedVisibility() {
            if (!this.removeInitialBinding()) {
                return;
            }
            if (BindingManagerImpl.this.mModerateBindingTillBackgrounded) {
                this.addConnectionToModerateBindingPool(this.mConnection);
            }
        }

        void setBoundForBackgroundPeriod(boolean nextBound) {
            if (!this.mBoundForBackgroundPeriod && nextBound) {
                this.addStrongBinding();
            } else if (this.mBoundForBackgroundPeriod && !nextBound) {
                this.removeStrongBinding(false);
            }
            this.mBoundForBackgroundPeriod = nextBound;
        }

        boolean isOomProtected() {
            return this.mConnection != null ? this.mConnection.isOomProtectedOrWasWhenDied() : this.mWasOomProtected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearConnection() {
            ModerateBindingPool moderateBindingPool;
            this.mWasOomProtected = this.mConnection.isOomProtectedOrWasWhenDied();
            Object object = BindingManagerImpl.this.mModerateBindingPoolLock;
            synchronized (object) {
                moderateBindingPool = BindingManagerImpl.this.mModerateBindingPool;
            }
            if (moderateBindingPool != null) {
                moderateBindingPool.removeConnection(this);
            }
            this.mConnection = null;
        }

        @VisibleForTesting
        boolean isConnectionCleared() {
            return this.mConnection == null;
        }
    }

    private static class ModerateBindingPool
    extends LruCache<Integer, ManagedConnection>
    implements ComponentCallbacks2 {
        private final Object mDelayedClearerLock = new Object();
        private Runnable mDelayedClearer;
        private final Handler mHandler = new Handler(ThreadUtils.getUiThreadLooper());

        public ModerateBindingPool(int maxSize) {
            super(maxSize);
        }

        public void onTrimMemory(int level) {
            Log.i(BindingManagerImpl.TAG, "onTrimMemory: level=%d, size=%d", level, this.size());
            if (this.size() > 0) {
                if (level <= 5) {
                    this.reduce(0.25f);
                } else if (level <= 10) {
                    this.reduce(0.5f);
                } else {
                    if (level == 20) {
                        return;
                    }
                    this.evictAll();
                }
            }
        }

        public void onLowMemory() {
            Log.i(BindingManagerImpl.TAG, "onLowMemory: evict %d bindings", this.size());
            this.evictAll();
        }

        public void onConfigurationChanged(Configuration configuration) {
        }

        @TargetApi(value=17)
        private void reduce(float reduceRatio) {
            int oldSize = this.size();
            int newSize = (int)((float)oldSize * (1.0f - reduceRatio));
            Log.i(BindingManagerImpl.TAG, "Reduce connections from %d to %d", oldSize, newSize);
            if (newSize == 0) {
                this.evictAll();
            } else if (Build.VERSION.SDK_INT >= 17) {
                this.trimToSize(newSize);
            } else {
                int count = 0;
                for (Map.Entry entry : this.snapshot().entrySet()) {
                    this.remove(entry.getKey());
                    if (++count != oldSize - newSize) continue;
                    break;
                }
            }
        }

        void addConnection(ManagedConnection managedConnection) {
            ChildProcessConnection connection = managedConnection.mConnection;
            if (connection != null && connection.isInSandbox()) {
                managedConnection.addModerateBinding();
                if (connection.isModerateBindingBound()) {
                    this.put(connection.getServiceNumber(), managedConnection);
                } else {
                    this.remove(connection.getServiceNumber());
                }
            }
        }

        void removeConnection(ManagedConnection managedConnection) {
            ChildProcessConnection connection = managedConnection.mConnection;
            if (connection != null && connection.isInSandbox()) {
                this.remove(connection.getServiceNumber());
            }
        }

        protected void entryRemoved(boolean evicted, Integer key, ManagedConnection oldValue, ManagedConnection newValue) {
            if (oldValue != newValue) {
                oldValue.removeModerateBinding();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onSentToBackground(final boolean onTesting) {
            if (this.size() == 0) {
                return;
            }
            Object object = this.mDelayedClearerLock;
            synchronized (object) {
                this.mDelayedClearer = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = ModerateBindingPool.this.mDelayedClearerLock;
                        synchronized (object) {
                            if (ModerateBindingPool.this.mDelayedClearer == null) {
                                return;
                            }
                            ModerateBindingPool.this.mDelayedClearer = null;
                        }
                        Log.i(BindingManagerImpl.TAG, "Release moderate connections: %d", ModerateBindingPool.this.size());
                        if (!onTesting) {
                            RecordHistogram.recordCountHistogram("Android.ModerateBindingCount", ModerateBindingPool.this.size());
                        }
                        ModerateBindingPool.this.evictAll();
                    }
                };
                this.mHandler.postDelayed(this.mDelayedClearer, 10000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onBroughtToForeground() {
            Object object = this.mDelayedClearerLock;
            synchronized (object) {
                if (this.mDelayedClearer == null) {
                    return;
                }
                this.mHandler.removeCallbacks(this.mDelayedClearer);
                this.mDelayedClearer = null;
            }
        }
    }
}

