/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.ServiceRegistry;
import org.chromium.device.battery.BatteryMonitorFactory;
import org.chromium.device.vibration.VibrationManagerImpl;
import org.chromium.mojom.device.BatteryMonitor;
import org.chromium.mojom.device.VibrationManager;

@JNINamespace(value="content")
class ServiceRegistrar {
    ServiceRegistrar() {
    }

    @CalledByNative
    static void registerProcessHostServices(ServiceRegistry registry, Context applicationContext) {
        assert (applicationContext != null);
        registry.addService(BatteryMonitor.MANAGER, new BatteryMonitorImplementationFactory(applicationContext));
    }

    @CalledByNative
    static void registerFrameHostServices(ServiceRegistry registry, Context applicationContext) {
        assert (applicationContext != null);
        registry.addService(VibrationManager.MANAGER, new VibrationManagerImplementationFactory(applicationContext));
    }

    private static class VibrationManagerImplementationFactory
    implements ServiceRegistry.ImplementationFactory<VibrationManager> {
        private final Context mApplicationContext;

        VibrationManagerImplementationFactory(Context applicationContext) {
            this.mApplicationContext = applicationContext;
        }

        @Override
        public VibrationManager createImpl() {
            return new VibrationManagerImpl(this.mApplicationContext);
        }
    }

    private static class BatteryMonitorImplementationFactory
    implements ServiceRegistry.ImplementationFactory<BatteryMonitor> {
        private final BatteryMonitorFactory mFactory;

        BatteryMonitorImplementationFactory(Context applicationContext) {
            this.mFactory = new BatteryMonitorFactory(applicationContext);
        }

        @Override
        public BatteryMonitor createImpl() {
            return this.mFactory.createMonitor();
        }
    }
}

