/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import org.chromium.content.browser.input.PastePopupMenu;

public class LegacyPastePopupMenu
implements View.OnClickListener,
PastePopupMenu {
    private final View mParent;
    private final PastePopupMenu.PastePopupMenuDelegate mDelegate;
    private final Context mContext;
    private final PopupWindow mContainer;
    private int mRawPositionX;
    private int mRawPositionY;
    private int mStatusBarHeight;
    private View mPasteView;
    private final int mPasteViewLayout;
    private final int mLineOffsetY;
    private final int mWidthOffsetX;

    public LegacyPastePopupMenu(Context context, View parent, final PastePopupMenu.PastePopupMenuDelegate delegate) {
        this.mParent = parent;
        this.mDelegate = delegate;
        this.mContext = context;
        this.mContainer = new PopupWindow(this.mContext, null, 16843464);
        this.mContainer.setSplitTouchEnabled(true);
        this.mContainer.setClippingEnabled(false);
        this.mContainer.setAnimationStyle(0);
        this.mContainer.setWidth(-2);
        this.mContainer.setHeight(-2);
        this.mContainer.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                delegate.onDismiss();
            }
        });
        int[] popupLayoutAttrs = new int[]{16843540};
        TypedArray attrs = this.mContext.getTheme().obtainStyledAttributes(popupLayoutAttrs);
        this.mPasteViewLayout = attrs.getResourceId(attrs.getIndex(0), 0);
        attrs.recycle();
        this.mLineOffsetY = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics());
        this.mWidthOffsetX = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics());
        int statusBarHeightResourceId = this.mContext.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (statusBarHeightResourceId > 0) {
            this.mStatusBarHeight = this.mContext.getResources().getDimensionPixelSize(statusBarHeightResourceId);
        }
    }

    @Override
    public void show(int x, int y) {
        this.updateContent();
        this.positionAt(x, y);
    }

    @Override
    public void hide() {
        this.mContainer.dismiss();
    }

    @Override
    public boolean isShowing() {
        return this.mContainer.isShowing();
    }

    public void onClick(View v) {
        this.paste();
        this.hide();
    }

    private void positionAt(int x, int y) {
        if (this.mRawPositionX == x && this.mRawPositionY == y && this.isShowing()) {
            return;
        }
        this.mRawPositionX = x;
        this.mRawPositionY = y;
        View contentView = this.mContainer.getContentView();
        int width = contentView.getMeasuredWidth();
        int height = contentView.getMeasuredHeight();
        int positionX = (int)((float)x - (float)width / 2.0f);
        int positionY = y - height - this.mLineOffsetY;
        int minOffsetY = 0;
        if (this.mParent.getSystemUiVisibility() == 0) {
            minOffsetY = this.mStatusBarHeight;
        }
        int screenWidth = this.mContext.getResources().getDisplayMetrics().widthPixels;
        if (positionY < minOffsetY) {
            positionY += height;
            positionY += this.mLineOffsetY;
            int handleHalfWidth = this.mWidthOffsetX / 2;
            positionX = x + width < screenWidth ? (positionX += handleHalfWidth + width / 2) : (positionX -= handleHalfWidth + width / 2);
        } else {
            positionX = Math.max(0, positionX);
            positionX = Math.min(screenWidth - width, positionX);
        }
        int[] coords = new int[2];
        this.mParent.getLocationInWindow(coords);
        positionX += coords[0];
        positionY += coords[1];
        if (!this.isShowing()) {
            this.mContainer.showAtLocation(this.mParent, 0, positionX, positionY);
        } else {
            this.mContainer.update(positionX, positionY, -1, -1);
        }
    }

    private void updateContent() {
        if (this.mPasteView == null) {
            LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
            if (inflater != null) {
                this.mPasteView = inflater.inflate(this.mPasteViewLayout, null);
            }
            if (this.mPasteView == null) {
                throw new IllegalArgumentException("Unable to inflate TextEdit paste window");
            }
            int size = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            this.mPasteView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            this.mPasteView.measure(size, size);
            this.mPasteView.setOnClickListener((View.OnClickListener)this);
        }
        this.mContainer.setContentView(this.mPasteView);
    }

    private void paste() {
        this.mDelegate.paste();
    }
}

