/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.os.Handler;
import android.os.HandlerThread;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import org.chromium.base.VisibleForTesting;
import org.chromium.content.browser.input.ChromiumBaseInputConnection;
import org.chromium.content.browser.input.ImeAdapter;
import org.chromium.content.browser.input.ImeUtils;
import org.chromium.content.browser.input.InputMethodManagerWrapper;
import org.chromium.content.browser.input.InputMethodUma;
import org.chromium.content.browser.input.ThreadedInputConnection;
import org.chromium.content.browser.input.ThreadedInputConnectionProxyView;

public class ThreadedInputConnectionFactory
implements ChromiumBaseInputConnection.Factory {
    private static final String TAG = "cr_Ime";
    private static final boolean DEBUG_LOGS = false;
    private static final int CHECK_REGISTER_RETRY = 1;
    private final Handler mHandler;
    private final InputMethodManagerWrapper mInputMethodManagerWrapper;
    private final InputMethodUma mInputMethodUma;
    private ThreadedInputConnectionProxyView mProxyView;
    private ThreadedInputConnection mThreadedInputConnection;
    private CheckInvalidator mCheckInvalidator;
    private boolean mReentrantTriggering;

    ThreadedInputConnectionFactory(InputMethodManagerWrapper inputMethodManagerWrapper) {
        this.mInputMethodManagerWrapper = inputMethodManagerWrapper;
        this.mHandler = this.createHandler();
        this.mInputMethodUma = this.createInputMethodUma();
    }

    @VisibleForTesting
    protected Handler createHandler() {
        HandlerThread thread = new HandlerThread("InputConnectionHandlerThread", 5);
        thread.start();
        return new Handler(thread.getLooper());
    }

    @VisibleForTesting
    protected ThreadedInputConnectionProxyView createProxyView(Handler handler, View containerView) {
        return new ThreadedInputConnectionProxyView(containerView.getContext(), handler, containerView);
    }

    @VisibleForTesting
    protected InputMethodUma createInputMethodUma() {
        return new InputMethodUma();
    }

    private boolean shouldTriggerDelayedOnCreateInputConnection() {
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            String className = ste.getClassName();
            if (className == null || !className.contains(ThreadedInputConnectionProxyView.class.getName()) && !className.contains("TestInputMethodManagerWrapper")) continue;
            return false;
        }
        return true;
    }

    @Override
    public ThreadedInputConnection initializeAndGet(View view, ImeAdapter imeAdapter, int inputType, int inputFlags, int selectionStart, int selectionEnd, EditorInfo outAttrs) {
        ImeUtils.checkOnUiThread();
        ImeUtils.computeEditorInfo(inputType, inputFlags, selectionStart, selectionEnd, outAttrs);
        if (this.mCheckInvalidator != null) {
            this.mCheckInvalidator.invalidate();
        }
        if (this.shouldTriggerDelayedOnCreateInputConnection()) {
            this.triggerDelayedOnCreateInputConnection(view);
            return null;
        }
        if (this.mThreadedInputConnection == null) {
            this.mThreadedInputConnection = new ThreadedInputConnection(view, imeAdapter, this.mHandler);
        } else {
            this.mThreadedInputConnection.resetOnUiThread();
        }
        return this.mThreadedInputConnection;
    }

    private void triggerDelayedOnCreateInputConnection(final View view) {
        if (this.mReentrantTriggering) {
            return;
        }
        if (!view.hasFocus() || !view.hasWindowFocus()) {
            return;
        }
        this.mCheckInvalidator = new CheckInvalidator();
        if (this.mProxyView == null) {
            this.mProxyView = this.createProxyView(this.mHandler, view);
        }
        this.mReentrantTriggering = true;
        this.mProxyView.requestFocus();
        this.mReentrantTriggering = false;
        view.getHandler().post(new Runnable(){

            @Override
            public void run() {
                if (ThreadedInputConnectionFactory.this.mCheckInvalidator.isInvalid()) {
                    return;
                }
                ThreadedInputConnectionFactory.this.mProxyView.onWindowFocusChanged(true);
                ThreadedInputConnectionFactory.this.mInputMethodManagerWrapper.isActive(view);
                ThreadedInputConnectionFactory.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ThreadedInputConnectionFactory.this.postCheckRegisterResultOnUiThread(view, ThreadedInputConnectionFactory.this.mCheckInvalidator, 1);
                    }
                });
            }
        });
    }

    private void postCheckRegisterResultOnUiThread(final View view, final CheckInvalidator checkInvalidator, final int retry) {
        Handler viewHandler = view.getHandler();
        if (viewHandler == null) {
            return;
        }
        viewHandler.post(new Runnable(){

            @Override
            public void run() {
                ThreadedInputConnectionFactory.this.checkRegisterResult(view, checkInvalidator, retry);
            }
        });
    }

    private void checkRegisterResult(View view, CheckInvalidator checkInvalidator, int retry) {
        if (this.mInputMethodManagerWrapper.isActive(this.mProxyView)) {
            this.mInputMethodUma.recordProxyViewSuccess();
            return;
        }
        if (checkInvalidator.isInvalid()) {
            return;
        }
        if (retry > 0) {
            this.postCheckRegisterResultOnUiThread(view, checkInvalidator, retry - 1);
            return;
        }
        this.onRegisterProxyViewFailed();
    }

    @VisibleForTesting
    protected void onRegisterProxyViewFailed() {
        this.mInputMethodUma.recordProxyViewFailure();
        throw new AssertionError((Object)"Failed to register proxy view");
    }

    @Override
    public Handler getHandler() {
        return this.mHandler;
    }

    @Override
    public void onWindowFocusChanged(boolean gainFocus) {
        if (!gainFocus && this.mCheckInvalidator != null) {
            this.mCheckInvalidator.invalidate();
        }
        if (this.mProxyView != null) {
            this.mProxyView.onOriginalViewWindowFocusChanged(gainFocus);
        }
    }

    @Override
    public void onViewFocusChanged(boolean gainFocus) {
        if (!gainFocus && this.mCheckInvalidator != null) {
            this.mCheckInvalidator.invalidate();
        }
        if (this.mProxyView != null) {
            this.mProxyView.onOriginalViewFocusChanged(gainFocus);
        }
    }

    @Override
    public void onViewAttachedToWindow() {
        if (this.mProxyView != null) {
            this.mProxyView.onOriginalViewAttachedToWindow();
        }
    }

    @Override
    public void onViewDetachedFromWindow() {
        if (this.mCheckInvalidator != null) {
            this.mCheckInvalidator.invalidate();
        }
        if (this.mProxyView != null) {
            this.mProxyView.onOriginalViewDetachedFromWindow();
        }
    }

    private static class CheckInvalidator {
        private boolean mInvalid;

        private CheckInvalidator() {
        }

        public void invalidate() {
            ImeUtils.checkOnUiThread();
            this.mInvalid = true;
        }

        public boolean isInvalid() {
            ImeUtils.checkOnUiThread();
            return this.mInvalid;
        }
    }
}

