/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import java.util.Locale;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;

@JNINamespace(value="media")
class MediaCodecUtil {
    private static final String TAG = "MediaCodecUtil";
    static final int MEDIA_CODEC_DECODER = 0;
    static final int MEDIA_CODEC_ENCODER = 1;

    MediaCodecUtil() {
    }

    public static boolean isSoftwareCodec(String name) {
        if (name.startsWith("OMX.google.")) {
            return true;
        }
        return !name.startsWith("OMX.");
    }

    @CalledByNative
    private static String getDefaultCodecName(String mime, int direction, boolean requireSoftwareCodec) {
        MediaCodecListHelper codecListHelper = new MediaCodecListHelper();
        int codecCount = codecListHelper.getCodecCount();
        for (int i = 0; i < codecCount; ++i) {
            int codecDirection;
            MediaCodecInfo info = codecListHelper.getCodecInfoAt(i);
            int n = codecDirection = info.isEncoder() ? 1 : 0;
            if (codecDirection != direction || requireSoftwareCodec && !MediaCodecUtil.isSoftwareCodec(info.getName())) continue;
            String[] supportedTypes = info.getSupportedTypes();
            for (int j = 0; j < supportedTypes.length; ++j) {
                if (!supportedTypes[j].equalsIgnoreCase(mime)) continue;
                return info.getName();
            }
        }
        Log.e(TAG, "Decoder for type %s is not supported on this device", mime);
        return "";
    }

    @CalledByNative
    private static int[] getEncoderColorFormatsForMime(String mime) {
        MediaCodecListHelper codecListHelper = new MediaCodecListHelper();
        int codecCount = codecListHelper.getCodecCount();
        for (int i = 0; i < codecCount; ++i) {
            MediaCodecInfo info = codecListHelper.getCodecInfoAt(i);
            if (!info.isEncoder()) continue;
            String[] supportedTypes = info.getSupportedTypes();
            for (int j = 0; j < supportedTypes.length; ++j) {
                if (!supportedTypes[j].equalsIgnoreCase(mime)) continue;
                return info.getCapabilitiesForType((String)supportedTypes[j]).colorFormats;
            }
        }
        return null;
    }

    @CalledByNative
    private static boolean canDecode(String mime, boolean isSecure) {
        CodecCreationInfo info = MediaCodecUtil.createDecoder(mime, isSecure, false);
        if (info.mediaCodec == null) {
            return false;
        }
        try {
            info.mediaCodec.release();
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Cannot release media codec", e);
        }
        return true;
    }

    static CodecCreationInfo createDecoder(String mime, boolean isSecure, boolean requireSoftwareCodec) {
        CodecCreationInfo result = new CodecCreationInfo();
        assert (result.mediaCodec == null);
        if (isSecure && Build.VERSION.SDK_INT < 18) {
            return result;
        }
        if (!MediaCodecUtil.isDecoderSupportedForDevice(mime)) {
            Log.e(TAG, "Decoder for type %s is not supported on this device", mime);
            return result;
        }
        try {
            if (mime.startsWith("video") && isSecure) {
                String decoderName = MediaCodecUtil.getDefaultCodecName(mime, 0, requireSoftwareCodec);
                if (decoderName.equals("")) {
                    return null;
                }
                if (Build.VERSION.SDK_INT >= 19) {
                    MediaCodec insecureCodec = MediaCodec.createByCodecName((String)decoderName);
                    result.supportsAdaptivePlayback = MediaCodecUtil.codecSupportsAdaptivePlayback(insecureCodec, mime);
                    insecureCodec.release();
                }
                result.mediaCodec = MediaCodec.createByCodecName((String)(decoderName + ".secure"));
            } else {
                if (requireSoftwareCodec) {
                    String decoderName = MediaCodecUtil.getDefaultCodecName(mime, 0, requireSoftwareCodec);
                    result.mediaCodec = MediaCodec.createByCodecName((String)decoderName);
                } else {
                    result.mediaCodec = MediaCodec.createDecoderByType((String)mime);
                }
                result.supportsAdaptivePlayback = MediaCodecUtil.codecSupportsAdaptivePlayback(result.mediaCodec, mime);
            }
        }
        catch (Exception e) {
            Log.e(TAG, "Failed to create MediaCodec: %s, isSecure: %s, requireSoftwareCodec: %s", mime, isSecure, requireSoftwareCodec ? "yes" : "no", e);
            result.mediaCodec = null;
        }
        return result;
    }

    @CalledByNative
    static boolean isDecoderSupportedForDevice(String mime) {
        if (mime.equals("video/x-vnd.on2.vp8")) {
            if (Build.MANUFACTURER.toLowerCase(Locale.getDefault()).equals("samsung")) {
                if (Build.VERSION.SDK_INT < 21 && (Build.MODEL.startsWith("GT-I9505") || Build.MODEL.startsWith("GT-I9500"))) {
                    return false;
                }
                if (Build.MODEL.startsWith("GT-I9190") || Build.MODEL.startsWith("GT-I9195")) {
                    return false;
                }
                if (Build.VERSION.SDK_INT < 19) {
                    if (Build.MODEL.startsWith("GT-")) {
                        return false;
                    }
                    if (Build.MODEL.startsWith("SCH-")) {
                        return false;
                    }
                    if (Build.MODEL.startsWith("SM-T")) {
                        return false;
                    }
                }
            }
            if (Build.HARDWARE.startsWith("mt")) {
                return false;
            }
        } else if (mime.equals("video/x-vnd.on2.vp9")) {
            if (Build.VERSION.SDK_INT < 19) {
                return false;
            }
            if (Build.VERSION.SDK_INT < 21 && Build.HARDWARE.startsWith("mt")) {
                return false;
            }
        } else if (mime.equals("audio/opus") && Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return true;
    }

    private static boolean isAdaptivePlaybackBlacklisted(String mime) {
        if (!mime.equals("video/avc") && !mime.equals("video/avc1")) {
            return false;
        }
        if (!Build.VERSION.RELEASE.equals("4.4.2")) {
            return false;
        }
        if (!Build.MANUFACTURER.toLowerCase(Locale.getDefault()).equals("samsung")) {
            return false;
        }
        return Build.MODEL.startsWith("GT-I9300") || Build.MODEL.startsWith("SCH-I535");
    }

    @TargetApi(value=19)
    private static boolean codecSupportsAdaptivePlayback(MediaCodec mediaCodec, String mime) {
        if (Build.VERSION.SDK_INT < 19 || mediaCodec == null) {
            return false;
        }
        try {
            MediaCodecInfo info = mediaCodec.getCodecInfo();
            if (info.isEncoder()) {
                return false;
            }
            if (MediaCodecUtil.isAdaptivePlaybackBlacklisted(mime)) {
                return false;
            }
            MediaCodecInfo.CodecCapabilities capabilities = info.getCapabilitiesForType(mime);
            return capabilities != null && capabilities.isFeatureSupported("adaptive-playback");
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Cannot retrieve codec information", e);
            return false;
        }
    }

    @MainDex
    private static class MediaCodecListHelper {
        private MediaCodecInfo[] mCodecList;

        @TargetApi(value=21)
        public MediaCodecListHelper() {
            if (this.hasNewMediaCodecList()) {
                this.mCodecList = new MediaCodecList(1).getCodecInfos();
            }
        }

        public int getCodecCount() {
            if (this.hasNewMediaCodecList()) {
                return this.mCodecList.length;
            }
            return MediaCodecList.getCodecCount();
        }

        public MediaCodecInfo getCodecInfoAt(int index) {
            if (this.hasNewMediaCodecList()) {
                return this.mCodecList[index];
            }
            return MediaCodecList.getCodecInfoAt((int)index);
        }

        private boolean hasNewMediaCodecList() {
            return Build.VERSION.SDK_INT >= 21;
        }
    }

    @MainDex
    public static final class MimeTypes {
        public static final String VIDEO_MP4 = "video/mp4";
        public static final String VIDEO_WEBM = "video/webm";
        public static final String VIDEO_H264 = "video/avc";
        public static final String VIDEO_H265 = "video/hevc";
        public static final String VIDEO_VP8 = "video/x-vnd.on2.vp8";
        public static final String VIDEO_VP9 = "video/x-vnd.on2.vp9";
    }

    @MainDex
    public static class CodecCreationInfo {
        public MediaCodec mediaCodec = null;
        public boolean supportsAdaptivePlayback = false;
    }
}

