/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.autofill;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.ui.R;
import org.chromium.ui.UiUtils;
import org.chromium.ui.autofill.AutofillDelegate;
import org.chromium.ui.autofill.AutofillSuggestion;
import org.chromium.ui.base.WindowAndroid;
import org.chromium.ui.gfx.DeviceDisplayInfo;

public class AutofillKeyboardAccessory
extends LinearLayout
implements WindowAndroid.KeyboardVisibilityListener,
View.OnClickListener,
View.OnLongClickListener {
    private final WindowAndroid mWindowAndroid;
    private final AutofillDelegate mAutofillDelegate;
    private final int mMaximumLabelWidthPx;
    private final int mMaximumSublabelWidthPx;

    public AutofillKeyboardAccessory(WindowAndroid windowAndroid, AutofillDelegate autofillDelegate) {
        super((Context)windowAndroid.getActivity().get());
        assert (autofillDelegate != null);
        assert (windowAndroid.getActivity().get() != null);
        this.mWindowAndroid = windowAndroid;
        this.mAutofillDelegate = autofillDelegate;
        int deviceWidthPx = DeviceDisplayInfo.create(this.getContext()).getDisplayWidth();
        this.mMaximumLabelWidthPx = deviceWidthPx / 2;
        this.mMaximumSublabelWidthPx = deviceWidthPx / 4;
        this.mWindowAndroid.addKeyboardVisibilityListener(this);
        int horizontalPaddingPx = this.getResources().getDimensionPixelSize(R.dimen.keyboard_accessory_half_padding);
        this.setPadding(horizontalPaddingPx, 0, horizontalPaddingPx, 0);
    }

    @SuppressLint(value={"InlinedApi"})
    public void showWithSuggestions(AutofillSuggestion[] suggestions, final boolean isRtl) {
        this.removeAllViews();
        int separatorPosition = -1;
        for (int i = 0; i < suggestions.length; ++i) {
            View touchTarget;
            AutofillSuggestion suggestion = suggestions[i];
            assert (!TextUtils.isEmpty((CharSequence)suggestion.getLabel()));
            if (!suggestion.isFillable() && suggestion.getIconId() != 0) {
                touchTarget = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.autofill_keyboard_accessory_icon, (ViewGroup)this, false);
                if (separatorPosition == -1) {
                    separatorPosition = i;
                }
                ImageView icon = (ImageView)touchTarget;
                icon.setImageResource(suggestion.getIconId());
                icon.setContentDescription((CharSequence)suggestion.getLabel());
            } else {
                touchTarget = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.autofill_keyboard_accessory_item, (ViewGroup)this, false);
                TextView label = (TextView)touchTarget.findViewById(R.id.autofill_keyboard_accessory_item_label);
                if (suggestion.isFillable()) {
                    label.setMaxWidth(this.mMaximumLabelWidthPx);
                }
                label.setText((CharSequence)suggestion.getLabel());
                if (Build.VERSION.SDK_INT < 21) {
                    label.setTypeface(Typeface.DEFAULT_BOLD);
                }
                if (suggestion.getIconId() != 0) {
                    ApiCompatibilityUtils.setCompoundDrawablesRelativeWithIntrinsicBounds(label, suggestion.getIconId(), 0, 0, 0);
                }
                if (!TextUtils.isEmpty((CharSequence)suggestion.getSublabel())) {
                    assert (suggestion.isFillable());
                    TextView sublabel = (TextView)touchTarget.findViewById(R.id.autofill_keyboard_accessory_item_sublabel);
                    sublabel.setText((CharSequence)suggestion.getSublabel());
                    sublabel.setVisibility(0);
                    sublabel.setMaxWidth(this.mMaximumSublabelWidthPx);
                }
            }
            touchTarget.setTag((Object)i);
            touchTarget.setOnClickListener((View.OnClickListener)this);
            if (suggestion.isDeletable()) {
                touchTarget.setOnLongClickListener((View.OnLongClickListener)this);
            }
            this.addView(touchTarget);
        }
        if (separatorPosition != -1) {
            View separator = new View(this.getContext());
            separator.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0, 1.0f));
            this.addView(separator, separatorPosition);
        }
        ApiCompatibilityUtils.setLayoutDirection((View)this, isRtl ? 1 : 0);
        final HorizontalScrollView container = (HorizontalScrollView)this.mWindowAndroid.getKeyboardAccessoryView();
        if (this.getParent() == null) {
            container.addView((View)this);
            container.setVisibility(0);
            container.sendAccessibilityEvent(32);
        }
        container.post(new Runnable(){

            @Override
            public void run() {
                container.scrollTo(isRtl ? AutofillKeyboardAccessory.this.getRight() : 0, 0);
            }
        });
    }

    public void dismiss() {
        ViewGroup container = this.mWindowAndroid.getKeyboardAccessoryView();
        container.removeView((View)this);
        container.setVisibility(8);
        this.mWindowAndroid.removeKeyboardVisibilityListener(this);
        ((View)container.getParent()).requestLayout();
    }

    @Override
    public void keyboardVisibilityChanged(boolean isShowing) {
        if (!isShowing) {
            this.dismiss();
            this.mAutofillDelegate.dismissed();
        }
    }

    public void onClick(View v) {
        UiUtils.hideKeyboard((View)this);
        this.mAutofillDelegate.suggestionSelected((Integer)v.getTag());
    }

    public boolean onLongClick(View v) {
        this.mAutofillDelegate.deleteSuggestion((Integer)v.getTag());
        return true;
    }
}

