/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.picker;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import org.chromium.ui.R;
import org.chromium.ui.picker.TwoFieldDatePicker;

public abstract class TwoFieldDatePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
TwoFieldDatePicker.OnMonthOrWeekChangedListener {
    private static final String YEAR = "year";
    private static final String POSITION_IN_YEAR = "position_in_year";
    protected final TwoFieldDatePicker mPicker;
    protected final OnValueSetListener mCallBack;

    public TwoFieldDatePickerDialog(Context context, OnValueSetListener callBack, int year, int positionInYear, double minValue, double maxValue) {
        this(context, 0, callBack, year, positionInYear, minValue, maxValue);
    }

    public TwoFieldDatePickerDialog(Context context, int theme, OnValueSetListener callBack, int year, int positionInYear, double minValue, double maxValue) {
        super(context, theme);
        this.mCallBack = callBack;
        this.setButton(-1, context.getText(R.string.date_picker_dialog_set), this);
        this.setButton(-2, context.getText(0x1040000), null);
        this.setIcon(0);
        this.mPicker = this.createPicker(context, minValue, maxValue);
        this.setView((View)this.mPicker);
        this.mPicker.init(year, positionInYear, this);
    }

    protected TwoFieldDatePicker createPicker(Context context, double minValue, double maxValue) {
        return null;
    }

    public void onClick(DialogInterface dialog, int which) {
        this.tryNotifyDateSet();
    }

    protected void tryNotifyDateSet() {
        if (this.mCallBack != null) {
            this.mPicker.clearFocus();
            this.mCallBack.onValueSet(this.mPicker.getYear(), this.mPicker.getPositionInYear());
        }
    }

    @Override
    public void onMonthOrWeekChanged(TwoFieldDatePicker view, int year, int positionInYear) {
        this.mPicker.init(year, positionInYear, null);
    }

    public void updateDate(int year, int weekOfYear) {
        this.mPicker.updateDate(year, weekOfYear);
    }

    public static interface OnValueSetListener {
        public void onValueSet(int var1, int var2);
    }
}

