/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.picker;

import android.content.Context;
import java.util.Calendar;
import java.util.TimeZone;
import org.chromium.ui.R;
import org.chromium.ui.picker.TwoFieldDatePicker;

public class WeekPicker
extends TwoFieldDatePicker {
    public WeekPicker(Context context, double minValue, double maxValue) {
        super(context, minValue, maxValue);
        this.getPositionInYearSpinner().setContentDescription((CharSequence)this.getResources().getString(R.string.accessibility_date_picker_week));
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.setTimeInMillis(System.currentTimeMillis());
        this.init(WeekPicker.getISOWeekYearForDate(cal), WeekPicker.getWeekForDate(cal), null);
    }

    public static Calendar createDateFromWeek(int year, int week) {
        Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        date.clear();
        date.setFirstDayOfWeek(2);
        date.setMinimalDaysInFirstWeek(4);
        date.set(7, 2);
        date.set(1, year);
        date.set(3, week);
        return date;
    }

    public static Calendar createDateFromValue(double value) {
        Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        date.clear();
        date.setFirstDayOfWeek(2);
        date.setMinimalDaysInFirstWeek(4);
        date.setTimeInMillis((long)value);
        return date;
    }

    @Override
    protected Calendar getDateForValue(double value) {
        return WeekPicker.createDateFromValue(value);
    }

    public static int getISOWeekYearForDate(Calendar date) {
        int year = date.get(1);
        int month = date.get(2);
        int week = date.get(3);
        if (month == 0 && week > 51) {
            --year;
        } else if (month == 11 && week == 1) {
            ++year;
        }
        return year;
    }

    public static int getWeekForDate(Calendar date) {
        return date.get(3);
    }

    @Override
    protected void setCurrentDate(int year, int week) {
        Calendar date = WeekPicker.createDateFromWeek(year, week);
        if (date.before(this.getMinDate())) {
            this.setCurrentDate(this.getMinDate());
        } else if (date.after(this.getMaxDate())) {
            this.setCurrentDate(this.getMaxDate());
        } else {
            this.setCurrentDate(date);
        }
    }

    private int getNumberOfWeeks(int year) {
        Calendar date = WeekPicker.createDateFromWeek(year, 20);
        return date.getActualMaximum(3);
    }

    @Override
    public int getYear() {
        return WeekPicker.getISOWeekYearForDate(this.getCurrentDate());
    }

    public int getWeek() {
        return WeekPicker.getWeekForDate(this.getCurrentDate());
    }

    @Override
    public int getPositionInYear() {
        return this.getWeek();
    }

    @Override
    protected int getMaxYear() {
        return WeekPicker.getISOWeekYearForDate(this.getMaxDate());
    }

    @Override
    protected int getMinYear() {
        return WeekPicker.getISOWeekYearForDate(this.getMinDate());
    }

    @Override
    protected int getMaxPositionInYear(int year) {
        if (year == WeekPicker.getISOWeekYearForDate(this.getMaxDate())) {
            return WeekPicker.getWeekForDate(this.getMaxDate());
        }
        return this.getNumberOfWeeks(year);
    }

    @Override
    protected int getMinPositionInYear(int year) {
        if (year == WeekPicker.getISOWeekYearForDate(this.getMinDate())) {
            return WeekPicker.getWeekForDate(this.getMinDate());
        }
        return 1;
    }
}

