/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.resources.statics;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.ui.resources.Resource;
import org.chromium.ui.resources.statics.NinePatchData;

public class StaticResource
implements Resource {
    private final Bitmap mBitmap;
    private final NinePatchData mNinePatchData;
    private final Rect mBitmapSize;

    public StaticResource(Bitmap bitmap) {
        this.mBitmap = bitmap;
        this.mNinePatchData = NinePatchData.create(this.mBitmap);
        this.mBitmapSize = new Rect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
    }

    @Override
    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    @Override
    public Rect getBitmapSize() {
        return this.mBitmapSize;
    }

    @Override
    public Rect getPadding() {
        return this.mNinePatchData != null ? this.mNinePatchData.getPadding() : this.mBitmapSize;
    }

    @Override
    public Rect getAperture() {
        return this.mNinePatchData != null ? this.mNinePatchData.getAperture() : this.mBitmapSize;
    }

    public static StaticResource create(Resources resources, int resId, int fitWidth, int fitHeight) {
        if (resId <= 0) {
            return null;
        }
        Bitmap bitmap = StaticResource.decodeBitmap(resources, resId, fitWidth, fitHeight);
        if (bitmap == null) {
            bitmap = StaticResource.decodeDrawable(resources, resId, fitWidth, fitHeight);
        }
        if (bitmap == null) {
            return null;
        }
        return new StaticResource(bitmap);
    }

    private static Bitmap decodeBitmap(Resources resources, int resId, int fitWidth, int fitHeight) {
        BitmapFactory.Options options = StaticResource.createOptions(resources, resId, fitWidth, fitHeight);
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)resources, (int)resId, (BitmapFactory.Options)options);
        if (bitmap == null) {
            return null;
        }
        if (bitmap.getConfig() == options.inPreferredConfig) {
            return bitmap;
        }
        Bitmap convertedBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)options.inPreferredConfig);
        Canvas canvas = new Canvas(convertedBitmap);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        bitmap.recycle();
        return convertedBitmap;
    }

    private static Bitmap decodeDrawable(Resources resources, int resId, int fitWidth, int fitHeight) {
        try {
            Drawable drawable2 = ApiCompatibilityUtils.getDrawable(resources, resId);
            int width = Math.max(drawable2.getMinimumWidth(), Math.max(fitWidth, 1));
            int height = Math.max(drawable2.getMinimumHeight(), Math.max(fitHeight, 1));
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, width, height);
            drawable2.draw(canvas);
            return bitmap;
        }
        catch (Resources.NotFoundException ex) {
            return null;
        }
    }

    private static BitmapFactory.Options createOptions(Resources resources, int resId, int fitWidth, int fitHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        if (fitWidth == 0 || fitHeight == 0) {
            return options;
        }
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)resources, (int)resId, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
        if (options.outHeight <= fitHeight && options.outWidth <= fitWidth) {
            return options;
        }
        int heightRatio = Math.round((float)options.outHeight / (float)fitHeight);
        int widthRatio = Math.round((float)options.outWidth / (float)fitWidth);
        options.inSampleSize = Math.min(heightRatio, widthRatio);
        return options;
    }
}

