/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.resources.system;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import org.chromium.ui.resources.Resource;
import org.chromium.ui.resources.ResourceLoader;
import org.chromium.ui.resources.async.AsyncPreloadResourceLoader;
import org.chromium.ui.resources.statics.StaticResource;

public class SystemResourceLoader
extends AsyncPreloadResourceLoader {
    private static final float SIN_PI_OVER_6 = 0.5f;
    private static final float COS_PI_OVER_6 = 0.866f;

    public SystemResourceLoader(int resourceType, ResourceLoader.ResourceLoaderCallback callback, final int minScreenSideLengthPx) {
        super(resourceType, callback, new AsyncPreloadResourceLoader.ResourceCreator(){

            @Override
            public Resource create(int resId) {
                return SystemResourceLoader.createResource(minScreenSideLengthPx, resId);
            }
        });
    }

    private static Resource createResource(int minScreenSideLengthPx, int resId) {
        switch (resId) {
            case 0: {
                return StaticResource.create(Resources.getSystem(), SystemResourceLoader.getResourceId("android:drawable/overscroll_edge"), 128, 12);
            }
            case 1: {
                return StaticResource.create(Resources.getSystem(), SystemResourceLoader.getResourceId("android:drawable/overscroll_glow"), 128, 64);
            }
            case 2: {
                return SystemResourceLoader.createOverscrollGlowLBitmap(minScreenSideLengthPx);
            }
        }
        assert (false);
        return null;
    }

    private static Resource createOverscrollGlowLBitmap(int minScreenSideLengthPx) {
        float arcWidth = (float)minScreenSideLengthPx * 0.5f / 0.5f;
        float y = 0.866f * arcWidth;
        float height = arcWidth - y;
        float arcRectX = -arcWidth / 2.0f;
        float arcRectY = -arcWidth - y;
        float arcRectWidth = arcWidth * 2.0f;
        float arcRectHeight = arcWidth * 2.0f;
        RectF arcRect = new RectF(arcRectX, arcRectY, arcRectX + arcRectWidth, arcRectY + arcRectHeight);
        Paint arcPaint = new Paint();
        arcPaint.setAntiAlias(true);
        arcPaint.setAlpha(187);
        arcPaint.setStyle(Paint.Style.FILL);
        Bitmap bitmap = Bitmap.createBitmap((int)((int)arcWidth), (int)((int)height), (Bitmap.Config)Bitmap.Config.ALPHA_8);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawArc(arcRect, 45.0f, 90.0f, true, arcPaint);
        return new StaticResource(bitmap);
    }

    private static int getResourceId(String name) {
        Resources systemResources = Resources.getSystem();
        return systemResources.getIdentifier(name, null, null);
    }
}

