/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.extension;

import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.xwalk.core.extension.MessageInfo;
import org.xwalk.core.extension.ReflectionHelper;

public class MessageHandler {
    private String TAG = "MessageHandler";
    private Map<String, Handler> mHandlers = new HashMap<String, Handler>();

    public MessageHandler() {
    }

    public MessageHandler(MessageHandler sourceHandler) {
        this.mHandlers.putAll(sourceHandler.mHandlers);
    }

    public void register(String jsName, String javaName, ReflectionHelper.MemberType type2, Object obj, ReflectionHelper reflection) {
        if (this.mHandlers.containsKey(jsName)) {
            Log.w((String)this.TAG, (String)("Existing handler for " + jsName));
            return;
        }
        Handler handler = new Handler(javaName, type2, obj, reflection);
        this.mHandlers.put(jsName, handler);
    }

    public void register(String jsName, String javaName, ReflectionHelper.MemberType type2, Object obj) {
        this.register(jsName, javaName, type2, obj, null);
    }

    public void register(String jsName, String javaName, Object obj) {
        this.register(jsName, javaName, ReflectionHelper.MemberType.JS_METHOD, obj, null);
    }

    public void register(String jsName, Object obj) {
        this.register(jsName, jsName, ReflectionHelper.MemberType.JS_METHOD, obj, null);
    }

    public Object handleMessage(MessageInfo info) {
        Object result = null;
        String jsName = info.getJsName();
        Handler handler = this.mHandlers.get(jsName);
        if (handler == null || handler.targetObject == null) {
            Log.w((String)this.TAG, (String)("Cannot find handler for method " + jsName));
            return result;
        }
        Object obj = handler.targetObject;
        if (info.getExtension().isAutoJS() && handler.reflection != null) {
            try {
                result = handler.reflection.handleMessage(info, obj);
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)e.toString());
            }
        } else {
            try {
                Method method = obj.getClass().getMethod(handler.javaName, MessageInfo.class);
                result = method.invoke(obj, info);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Log.e((String)this.TAG, (String)e.toString());
            }
        }
        return result;
    }

    public class Handler {
        ReflectionHelper.MemberType type;
        String javaName;
        Object targetObject;
        ReflectionHelper reflection;

        public Handler(String javaName, ReflectionHelper.MemberType type2, Object object, ReflectionHelper reflection) {
            this.type = type2;
            this.javaName = javaName;
            this.targetObject = object;
            this.reflection = reflection;
        }

        public Handler(String javaName, ReflectionHelper.MemberType type2, Object object) {
            this(javaName, type2, object, null);
        }
    }
}

