/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.content.Context;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="xwalk")
class XWalkDevToolsServer {
    private static final String DEBUG_PERMISSION_SIFFIX = ".permission.DEBUG";
    private long mNativeDevToolsServer = 0L;
    private String mSocketName = null;

    public XWalkDevToolsServer(String socketName) {
        this.mNativeDevToolsServer = this.nativeInitRemoteDebugging(socketName);
        this.mSocketName = socketName;
    }

    public void destroy() {
        this.nativeDestroyRemoteDebugging(this.mNativeDevToolsServer);
        this.mNativeDevToolsServer = 0L;
    }

    public boolean isRemoteDebuggingEnabled() {
        return this.nativeIsRemoteDebuggingEnabled(this.mNativeDevToolsServer);
    }

    public void setRemoteDebuggingEnabled(boolean enabled, Security security) {
        boolean allowDebugPermission = security == Security.ALLOW_DEBUG_PERMISSION;
        boolean allowSocketAccess = security == Security.ALLOW_SOCKET_ACCESS;
        this.nativeSetRemoteDebuggingEnabled(this.mNativeDevToolsServer, enabled, allowDebugPermission, allowSocketAccess);
    }

    public void setRemoteDebuggingEnabled(boolean enabled) {
        this.setRemoteDebuggingEnabled(enabled, Security.DEFAULT);
    }

    public String getSocketName() {
        return this.mSocketName;
    }

    private native long nativeInitRemoteDebugging(String var1);

    private native void nativeDestroyRemoteDebugging(long var1);

    private native boolean nativeIsRemoteDebuggingEnabled(long var1);

    private native void nativeSetRemoteDebuggingEnabled(long var1, boolean var3, boolean var4, boolean var5);

    @CalledByNative
    private static boolean checkDebugPermission(Context context, int pid, int uid) {
        String debugPermissionName = context.getPackageName() + DEBUG_PERMISSION_SIFFIX;
        return context.checkPermission(debugPermissionName, pid, uid) == 0;
    }

    public static enum Security {
        DEFAULT,
        ALLOW_DEBUG_PERMISSION,
        ALLOW_SOCKET_ACCESS;

    }
}

