/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api;

import android.content.Context;
import android.os.Build;
import android.view.Display;
import java.util.ArrayList;
import org.xwalk.core.internal.extension.api.DisplayManagerJBMR1;
import org.xwalk.core.internal.extension.api.DisplayManagerNull;

public abstract class XWalkDisplayManager {
    protected final ArrayList<DisplayListener> mListeners = new ArrayList();
    private static XWalkDisplayManager mInstance;
    private static Context mContext;

    public static XWalkDisplayManager getInstance(Context context) {
        if (mContext != null) {
            assert (context.getApplicationContext() == mContext);
        } else {
            mContext = context.getApplicationContext();
        }
        if (mInstance == null) {
            mInstance = Build.VERSION.SDK_INT >= 17 ? new DisplayManagerJBMR1(mContext) : new DisplayManagerNull();
        }
        return mInstance;
    }

    public abstract Display getDisplay(int var1);

    public abstract Display[] getDisplays();

    public abstract Display[] getDisplays(String var1);

    public abstract Display[] getPresentationDisplays();

    public void registerDisplayListener(DisplayListener listener) {
        this.mListeners.add(listener);
    }

    public void unregisterDisplayListener(DisplayListener listener) {
        this.mListeners.remove(listener);
    }

    protected void notifyDisplayAdded(int displayId) {
        for (DisplayListener listener : this.mListeners) {
            listener.onDisplayAdded(displayId);
        }
    }

    protected void notifyDisplayRemoved(int displayId) {
        for (DisplayListener listener : this.mListeners) {
            listener.onDisplayRemoved(displayId);
        }
    }

    protected void notifyDisplayChanged(int displayId) {
        for (DisplayListener listener : this.mListeners) {
            listener.onDisplayChanged(displayId);
        }
    }

    public static interface DisplayListener {
        public void onDisplayAdded(int var1);

        public void onDisplayRemoved(int var1);

        public void onDisplayChanged(int var1);
    }
}

