package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONObject;

import jp.agentec.abook.abv.bl.acms.client.json.AcmsCommonJSON;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;

/**
 * Created by leej on 2018/10/26.
 */

public class SceneEntryJSON extends AcmsCommonJSON {
    private static final String ResourceId = "resourceId";

    public Integer resourceId;

    public SceneEntryJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {
        super.parse(json);
        if (json.has(ResourceId)) {
            resourceId = getInt(json, ResourceId);
        }
    }
}
