package jp.agentec.abook.abv.bl.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import jp.agentec.abook.abv.bl.acms.client.json.content.ContentJSON;
import jp.agentec.abook.abv.bl.acms.type.DeliveryType;
import jp.agentec.abook.abv.bl.acms.type.DownloadStatusType;
import jp.agentec.adf.net.http.HttpFileDownloader;


public class ContentDto extends AbstractDto implements Serializable {
	
	private static final long serialVersionUID = -8770196502886108061L;
	
	public long contentId;
	public String contentName;
	public String contentNameKana;
	public String contentDetail;
	public int allPageNum;
	public int orientation = -1;
	public boolean updatedFlg;
	public boolean downloadedFlg;
	public boolean downloadingFlg;
	public int metaVersion;
	public int resourceVersion;
	public Date deliveryStartDate;
	public Date deliveryEndDate;
	public boolean favoriteFlg;
	public boolean contentProtectedFlg;
	public String thumbnailNormalPath;
	public String thumbnailBigPath;
	public String pagePath;// 詳細画面用のZIPファイルPath
	public String resourcePath;
	public String contentGroups;
	public boolean newFlg;
	public int contractContentId;
	public Date readingDate;
	public Integer lastViewedPage;
	public Integer contentSize;
	public int readingCount;
	public String contentType;
	public Date lastDeliveryDate;
	public int alertMessageLevel;
	public String alertMessage;
	public boolean disableAutoDl;
	public String productId;
	public int deliveryType;
	public boolean disableSwipe;
	public boolean commonContentFlg;

	// DBにあるがinsertにはなし
	public String price;
	public int purchaseState = -1;
	public String purchaseToken;
	public int detailPageNum;
	public String status; // ContentDownloadQueueDtoから移動 (getUpdateValuesあり）
	public Date downloadStartDate; // ContentDownloadQueueDtoから移動 (getUpdateValuesあり）
	public Date downloadEndDate; // ContentDownloadQueueDtoから移動
	public int downloadProgress; // ContentDownloadQueueDtoから移動
	public long downloadedBytes; // ContentDownloadQueueDtoから移動
	public boolean logSendedFlg; // ContentDownloadQueueDtoから移動
	
	// 以下DB保存なし
	public List<ContentPageDto> pages;
	public int categoryId;
	public String[] tags;
	public int[] groupIds;
	public boolean isChecked;
	public String categoryNames;
	public String groupNames;
	public String shortUrl;
	public transient int browserType;
	public transient boolean downloadable = true; // ダウンロード可能かどうか（決済で使用）
	// ダウンロード関連
	public transient HttpFileDownloader downloader;
	public transient boolean autoPaused;
	//ABookSee用：権限のないコンテンツのフラグ
	public boolean isUnAuthorizedContent;

	public ContentDto(long contentId, int metaVersion, int resourceVersion, String contentNamaKana, int contentType) {
		this.contentId = contentId;
		this.metaVersion = metaVersion;
		this.resourceVersion = resourceVersion;
		this.contentNameKana = contentNamaKana;
		setContentType(contentType);
	}

	@Override
	public Object[] getInsertValues() {
		return new Object[]{contentId, contentName, contentNameKana, contentDetail, allPageNum, orientation, updatedFlg, downloadedFlg, downloadingFlg, metaVersion, resourceVersion, deliveryStartDate, deliveryEndDate, favoriteFlg, contentProtectedFlg, thumbnailNormalPath, thumbnailBigPath, pagePath, resourcePath, contentGroups, newFlg, contractContentId, readingDate, lastViewedPage, contentSize, readingCount, contentType, lastDeliveryDate, alertMessageLevel, alertMessage, disableAutoDl, productId, deliveryType, disableSwipe, isUnAuthorizedContent, commonContentFlg};
	}

	@Override
	public Object[] getUpdateValues() {
		return new Object[]{contentName, contentNameKana, contentDetail, allPageNum, orientation, updatedFlg, downloadedFlg, downloadingFlg, metaVersion, resourceVersion, deliveryStartDate, deliveryEndDate, favoriteFlg, contentProtectedFlg, thumbnailNormalPath, thumbnailBigPath, pagePath, resourcePath, contentGroups, newFlg, contractContentId, readingDate, lastViewedPage, contentSize, readingCount, contentType, lastDeliveryDate, alertMessageLevel, alertMessage, disableAutoDl, productId, deliveryType, disableSwipe, downloadStartDate, status, commonContentFlg, contentId};
	}
	
	public ContentDto() {
		this.updatedFlg = false; // TODO: なぜtrueになっていた？
		this.downloadedFlg = false;
		this.downloadingFlg = false;
		this.favoriteFlg = false;
		this.isChecked = false;
	}
	
	@Override
	public String[] getKeyValues() {
		return new String[] {""+ contentId};
	}

	public void setGroupIds(int[] groupIds) {
		String contentGroup = "";
		if (groupIds != null) {
			StringBuffer sb = new StringBuffer();
			for (int i = 0; i < groupIds.length; i++) {
				sb.append(groupIds[i]);
				sb.append(",");
			}
			contentGroup = sb.toString();
			contentGroup = contentGroup.substring(0, contentGroup.length() - 1);
		}
		this.contentGroups = contentGroup;
		this.groupIds = groupIds;
	}

	public boolean equalsVersion(ContentDto dto) {
		boolean result = false;
		
		if (dto != null) {
			if (contentId == dto.contentId && resourceVersion == dto.resourceVersion
					&& metaVersion == dto.metaVersion) {
				result = true;
			}
		}
		
		return result;
	}

	private static final int PDF_TYPE                =   0;  //PDF(OFFICE)タイプ
	private static final int HTML_TYPE               =   1;  //HTMLタイプ
	private static final int IMAGE_TYPE              =   2;  //画像タイプ
	private static final int MOVIE_TYPE              =   3;  //動画タイプ
	private static final int SOUND_TYPE              =   4;  //音声タイプ
	private static final int OTHER_TYPE              =   5;  //その他
	private static final int LINK_TYPE               =   6;  //URLリンクタイプ
	private static final int ENQUETE_TYPE            =   8;  //アンケート
	private static final int NONE_TYPE               =   9;  //オリジナル
	private static final int EXAM_TYPE               =   10;  //試験
	private static final int QUIZ_TYPE               =   11;  //クイズ
	private static final int PANO_MOVIE_TYPE         =   12;  //360°動画
	private static final int PANO_IMAGE_TYPE         =   13;  //バーチャルツアー
	private static final int OBJECTVR_TYPE           =   14;  //オブジェクト360

	private void setContentType(int contentType) { // contentVersionとjsonファイルがそれぞれintと文字列で異なるためマッピング
		switch (contentType) {
		case PDF_TYPE:
			this.contentType = ContentJSON.KEY_PDF_TYPE;
			break;
		case HTML_TYPE:
			this.contentType = ContentJSON.KEY_HTML_TYPE;
			break;
		case IMAGE_TYPE:
			this.contentType = ContentJSON.KEY_IMAGE_TYPE;
			break;
		case MOVIE_TYPE:
			this.contentType = ContentJSON.KEY_MOVIE_TYPE;
			break;
		case PANO_MOVIE_TYPE:
			this.contentType = ContentJSON.KEY_PANO_MOVIE_TYPE;
			break;
		case PANO_IMAGE_TYPE:
			this.contentType = ContentJSON.KEY_PANO_IMAGE_TYPE;
			break;
		case OBJECTVR_TYPE:
				this.contentType = ContentJSON.KEY_OBJECTVR_TYPE;
				break;
		case SOUND_TYPE:
			this.contentType = ContentJSON.KEY_MUSIC_TYPE;
			break;
		case OTHER_TYPE:
			this.contentType = ContentJSON.KEY_OTHER_TYPE;
			break;
		case LINK_TYPE:
			this.contentType = ContentJSON.KEY_LINK_TYPE;
			break;
		case ENQUETE_TYPE:
			this.contentType = ContentJSON.KEY_ENQUETE_TYPE;
			break;
		case NONE_TYPE:
			this.contentType = ContentJSON.KEY_NONE_TYPE;
			break;
		case EXAM_TYPE:
			this.contentType = ContentJSON.KEY_EXAM_TYPE;
			break;
		}
	}

	public boolean isOtherType() {
		return contentType != null && ContentJSON.KEY_OTHER_TYPE.equals(contentType.toLowerCase(Locale.US));
	}

	public boolean isLinkType() {
		return contentType != null && ContentJSON.KEY_LINK_TYPE.equals(contentType.toLowerCase(Locale.US));
	}
	
	public boolean isDownloadable(boolean checkDisableAutoDl) {
		return (!checkDisableAutoDl || !disableAutoDl) && deliveryType != DeliveryType.STREAMING;
	}

	public boolean isPdf() {
		return contentType != null && ContentJSON.KEY_PDF_TYPE.equals(contentType.toLowerCase(Locale.US));
	}

	public boolean isMovie() {
		return contentType != null && ContentJSON.KEY_MOVIE_TYPE.equals(contentType.toLowerCase(Locale.US));
	}

	public boolean isPanoImage() {
		return contentType != null && ContentJSON.KEY_PANO_IMAGE_TYPE.equals(contentType);
	}

	public DownloadStatusType getDownloadStatus() {
		return DownloadStatusType.parse(status);
	}
	
	public boolean isDownloadWaiting() {
		return getDownloadStatus() == DownloadStatusType.Waiting;
	}

	public boolean isDownloading() {
		return getDownloadStatus() == DownloadStatusType.Downloading;
	}
	
	public boolean isDownloadPaused() {
		return getDownloadStatus() == DownloadStatusType.Paused || getDownloadStatus() == DownloadStatusType.AutoPaused;
	}

	public boolean isDownloadInitializing() {
		return getDownloadStatus() == DownloadStatusType.Initializing;
	}

	public boolean isDownloadSucceeded() {
		return getDownloadStatus() == DownloadStatusType.Succeeded;
	}

	public boolean isPanoMovie() {
        return contentType != null  && ContentJSON.KEY_PANO_MOVIE_TYPE.equals(contentType);
    }

}
