package jp.agentec.abook.abv.bl.dto;

import java.util.Date;
import java.util.List;

/**
 * Created by leej on 2018/08/17.
 */

public class OperationDto extends AbstractDto {

    public Long operationId;
    public int operationType;
    public String operationName;
    public String operationDescriptions;
    public Date operationStartDate;
    public Date operationEndDate;
    public Date lastEditDate;
    public boolean editLockFlg;
    public boolean needSyncFlg;
    public boolean contentCreatingFlg;
    public Long contentId;
    public List<OperationContentDto> operationContentDtoList;
    public List<TaskDto> taskDtoList;
    public List<PushMessageDto> pushMessageList;
    public int reportType;  // 報告タイプ 0 : 報告 1 : 定期点検 2 : 報告（回答）
    public int reportCycle;         //0:日次 1:月次 2:年次
    public int enableReportUpdate; //0:不可 1:可
    public String reportPeriod;     //定期点検、2018/12/20 08:10:00 ~ 2018/12/21 18:10:00
    public int reportCount;         //定期点検、作業数
    public int enableReportHistory;    // 0: 履歴無し, 1: 履歴可
    public int enableReportEdit;    // 作業編集可能区分
    public int enableAddReport;     // 作業追加区分

    // 作業担当グループリスト
    public List<TaskWorkerGroupDto> taskWorkerGroupDtoList;

    public boolean equalsLastEdit(OperationDto dto) {
        if (dto != null) {
            if (operationId.equals(dto.operationId) && lastEditDate.equals(dto.lastEditDate)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object[] getInsertValues() {
        return new Object[] { operationId, operationName, operationDescriptions, operationStartDate, operationEndDate, operationType, reportType, lastEditDate, contentCreatingFlg, editLockFlg, needSyncFlg, reportCycle, enableReportUpdate, enableReportHistory, enableReportEdit, enableAddReport  };
    }

    @Override
    public Object[] getUpdateValues() {
        return new Object[] { operationName, operationDescriptions, operationStartDate, operationEndDate, operationType, reportType, lastEditDate, contentCreatingFlg, editLockFlg, needSyncFlg, reportCycle, enableReportUpdate, enableReportHistory, enableReportEdit, enableAddReport, operationId };
    }

    @Override
    public String[] getKeyValues() {
        return new String[] { "" + operationId };
    }
}
