package jp.agentec.abook.abv.bl.dto;

/**
 * SPP通信の端末情報DTO
 */

public class SppDeviceDto extends AbstractDto {

    // SPP通信端末ID
    public Integer sppDeviceId;
    // SPP通信端末名
    public String sppDeviceName;
    // 取得したいデータの開始時点
    public Integer dataStartIndex;
    // 取得したいデータの終了時点
    public Integer dataEndIndex;
    // ペアリング端末名
    public String pairingDeviceName;
    // ペアリング端末アドレス
    public String pairingDeviceAddress;

    @Override
    public Object[] getInsertValues() {
        return new Object[] { sppDeviceId, sppDeviceName, dataStartIndex, dataEndIndex, pairingDeviceName, pairingDeviceAddress };
    }

    @Override
    public Object[] getUpdateValues() {
        return new Object[] { sppDeviceName, dataStartIndex, dataEndIndex, pairingDeviceName, pairingDeviceAddress, sppDeviceId };
    }

    @Override
    public String[] getKeyValues() {
        return new String[] { "" + sppDeviceId };
    }
}
