package jp.agentec.abook.abv.bl.logic;

import java.io.IOException;
import java.util.Map;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.acms.client.json.MasterDataJSON;
import jp.agentec.abook.abv.bl.acms.client.parameters.FetchDateParameters;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.exception.ABVException;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.adf.util.FileUtil;

public class MasterDataLogic extends AbstractLogic {
    private static final java.lang.String TAG = "MasterDataLogic";

	/**
	 * グループ情報をサーバから受信し、ローカルに保存します。既存のデータは上書きされます。また、サーバにないグループがローカルにある場合、そのグループは削除されます。
     * マスタデータ情報をサーバから受信し、ローカルにJSONで保存する。で、
     * データ単位で項目はあるが要素が０件のデータは削除、
     * データ単位で項目が存在しないデータは変更無し
	 * @throws ABVException　キャッシュにユーザ情報がありません。再度ログインする必要があります。
	 * @throws AcmsException 
	 * @throws Exception その他、例外です。
	 * @since 1.0.0
	 */
	public String initializeMasterData(String lastFetchDate) {
		String fetchDate = null;
		try {
			FetchDateParameters param = new FetchDateParameters(cache.getMemberInfo().sid, lastFetchDate);
			MasterDataJSON masterDataJson = AcmsClient.getInstance(cache.getUrlPath(), networkAdapter).masterData(param);

			// get MAP
			Map<String, String> masterDataMap = masterDataJson.masterDataMap;

			// Map に保存されたデータをJSONに変換する。
			for (Map.Entry<String, String> entry : masterDataMap.entrySet()) {
				System.out.println(entry.getKey() + ":" + entry.getValue());
				try {
					createMasterDataJson(entry.getKey(), entry.getValue());
				} catch (IOException e) {
					Logger.e(TAG, "masterDataJSON error : ", e);
					throw e;
				}
			}
			fetchDate = masterDataJson.fetchDate;
		} catch (Exception e) {
			Logger.e(TAG, "masterDataSend error : ", e);
		}
		// masterData の fetchDateを渡す。
		return fetchDate;
	}

	/**
	 * content.jsonファイル作成
	 *
	 * @param jsonKeyData
	 * @param jsonValueData
	 * @throws IOException
	 */
	private void createMasterDataJson(String jsonKeyData, String jsonValueData) throws IOException {
		// マスタデータの保存されるパース
		String masterDataJsonPath = ABVEnvironment.getInstance().getMasterFilePath() + "/" + jsonKeyData + ".json";
		if (jsonValueData.contains(",")) {
			// マスタデータのJSONのパース設定
			FileUtil.createFile(masterDataJsonPath, jsonValueData);
		} else {
			// データ単位で項目はあるが要素が０件のデータは削除
			FileUtil.deleteFileOnly(masterDataJsonPath);
		}
	}

}
