package jp.agentec.adf.util;


/**
 * 配列に関する機能を提供します。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class ArrayUtil {
	/**
	 * 配列がnullか、又は配列の要素が０個かを示します。
	 * @param arr　テストする配列です。
	 * @return　配列がnullか、又は配列の要素が０個である場合、trueを返します。
	 * @since 1.0.0
	 */
	public static <T> boolean isNullOrEmpty(T[] arr) {
		return (arr == null || arr.length == 0);
	}
	
	/**
	 * 配列がnullか、又は配列の要素が０個かを示します。
	 * @param arr　テストする配列です。
	 * @return　配列がnullか、又は配列の要素が０個である場合、trueを返します。
	 * @since 1.0.0
	 */
	public static boolean isNullOrEmpty(byte[] arr) {
		return (arr == null || arr.length == 0);
	}
	
	/**
	 * 配列がnullか、又は配列の要素が０個かを示します。
	 * @param arr　テストする配列です。
	 * @return　配列がnullか、又は配列の要素が０個である場合、trueを返します。
	 * @since 1.0.0
	 */
	public static boolean isNullOrEmpty(int[] arr) {
		return (arr == null || arr.length == 0);
	}
	
	/**
	 * 配列がnullか、又は配列の要素が０個かを示します。
	 * @param arr　テストする配列です。
	 * @return　配列がnullか、又は配列の要素が０個である場合、trueを返します。
	 * @since 1.0.0
	 */
	public static boolean isNullOrEmpty(short[] arr) {
		return (arr == null || arr.length == 0);
	}
	
	/**
	 * 配列がnullか、又は配列の要素が０個かを示します。
	 * @param arr　テストする配列です。
	 * @return　配列がnullか、又は配列の要素が０個である場合、trueを返します。
	 * @since 1.0.0
	 */
	public static boolean isNullOrEmpty(long[] arr) {
		return (arr == null || arr.length == 0);
	}
	
	/**
	 * 配列がnullか、又は配列の要素が０個かを示します。
	 * @param arr　テストする配列です。
	 * @return　配列がnullか、又は配列の要素が０個である場合、trueを返します。
	 * @since 1.0.0
	 */
	public static boolean isNullOrEmpty(double[] arr) {
		return (arr == null || arr.length == 0);
	}
	
	/**
	 * 配列がnullか、又は配列の要素が０個かを示します。
	 * @param arr　テストする配列です。
	 * @return　配列がnullか、又は配列の要素が０個である場合、trueを返します。
	 * @since 1.0.0
	 */
	public static boolean isNullOrEmpty(float[] arr) {
		return (arr == null || arr.length == 0);
	}

	/**
	 * 配列を結合して文字列にする
	 * 
	 */
	public static String join(Object[] objs, String sep) {
		if (objs == null) {
			return null;
		}
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < objs.length; i++) {
			Object obj = objs[i];
			sb.append(obj);
			if (i != objs.length - 1) {
				sb.append(sep);
			}
		}
		return sb.toString();
	}

	public static boolean equalsAny(Object target, Object... array) {
		if (target == null || array == null) {
			return false;
		}
		for (Object obj : array) {
			if (obj.equals(target)) {
				return true;
			}
		}
		return false;
	}
}
