package jp.agentec.adf.util;

/**
 * 数字型を扱う機能を提供します。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class NumericUtil {
	/**
	 * 指定したクラスが数字型かどうかを示します。
	 * @param type テストするクラスです。
	 * @return typeがBigDecimal, BigInteger, Byte, Double, Float, Integer, Long, Short又はbyte, double, float, int, long, shortのクラスだとtrueを返します。
	 * @see Number
	 * @since 1.0.0
	 */
	public static boolean isNumberType(Class<?> type) {
		boolean isNumber = false;

		if (type != null) {
			if ((type.getSuperclass() != null && type.getSuperclass().equals(Number.class))
					|| type.equals(int.class) || type.equals(long.class) || type.equals(double.class)
					|| type.equals(float.class) || type.equals(byte.class) || type.equals(short.class)) {
				isNumber = true;
			}
		}
		
		return isNumber;
	}
	
	/**
	 * 指定した値が数字かどうかを示します。
	 * @param value テストする値です。
	 * @return valueが数字であればtrueを返します。
	 * @since 1.0.0
	 */
	@Deprecated
	public static boolean isNumber(Object value) {
		boolean isNumber = false;
		
		if (value != null) {
			isNumber = (value instanceof Number || isNumberType(value.getClass()));
		}
		
		return isNumber;
	}
	
	/**
	 * 指定した文字列をint型に変換します。
	 * @param s 数字に変換する文字列です。
	 * @return 変換した数字を返します。文字列が数字に変換することができない場合、0を返します。
	 * @since 1.0.0
	 */
	public static int parseInt(String s) {
		return parseInt(s, 0);
	}
	
	/**
	 * 指定した文字列をint型に変換します。
	 * @param s 数字に変換する文字列です。
	 * @param defaultValue 文字列が数字に変換することができない場合、使用するデフォルト値です。
	 * @return 変換した数字を返します。文字列が数字に変換することができない場合、defaultValueを返します。
	 * @since 1.0.0
	 */
	public static int parseInt(String s, int defaultValue) {
		int result = defaultValue;
		
		if (!StringUtil.isNullOrWhiteSpace(s)) {
			try {
				result = Integer.parseInt(s);
			} catch (Exception e) {
			}
		}
		
		return result;
	}
	
	/**
	 * {@link Integer} 型をint型に変換します。
	 * @param n　変換する数字です。
	 * @return　変換した数字を返します。nがnullである場合、0を返します。
	 * @since 1.0.0
	 */
	public static int parseInt(Integer n) {
		return parseInt(n, 0);
	}
	
	/**
	 * {@link Integer} 型をint型に変換します。
	 * @param n　変換する数字です。
	 * @param defaultValue　nがnullである場合、使用するデフォルト値です。
	 * @return　変換した数字を返します。nがnullである場合、defaultValueを返します。
	 * @since 1.0.0
	 */
	public static int parseInt(Integer n, int defaultValue) {
		if (n != null) {
			return n;
		} else {
			return defaultValue;
		}
	}
	
	/**
	 * 指定した文字列をlong型に変換します。
	 * @param s 数字に変換する文字列です。
	 * @return 変換した数字を返します。文字列が数字に変換することができない場合、0を返します。
	 * @since 1.0.0
	 */
	public static long parseLong(String s) {
		return parseLong(s, 0);
	}
	
	/**
	 * 指定した文字列をlong型に変換します。
	 * @param s 数字に変換する文字列です。
	 * @param defaultValue 文字列が数字に変換することができない場合、使用するデフォルト値です。
	 * @return 変換した数字を返します。文字列が数字に変換することができない場合、defaultValueを返します。
	 * @since 1.0.0
	 */
	public static long parseLong(String s, int defaultValue) {
		long result = defaultValue;
		
		if (!StringUtil.isNullOrWhiteSpace(s)) {
			try {
				result = Long.parseLong(s);
			} catch (Exception e) {
			}
		}
		
		return result;
	}
	
	/**
	 * {@link Long} 型をint型に変換します。
	 * @param n　変換する数字です。
	 * @return　変換した数字を返します。nがnullである場合、0を返します。
	 * @since 1.0.0
	 */
	public static long parseInt(Long n) {
		return parseInt(n, 0);
	}
	
	/**
	 * {@link Long} 型をint型に変換します。
	 * @param n　変換する数字です。
	 * @param defaultValue　nがnullである場合、使用するデフォルト値です。
	 * @return　変換した数字を返します。nがnullである場合、defaultValueを返します。
	 * @since 1.0.0
	 */
	public static long parseInt(Long n, int defaultValue) {
		if (n != null) {
			return n;
		} else {
			return defaultValue;
		}
	}
	
	/**
	 * {@link Boolean} 型をint型に変換します。
	 * @param b　変換する値です。
	 * @return 変換した数字を返します。bがnullである場合、0を返します。
	 * @since 1.0.0
	 */
	public static int parseInt(Boolean b) {
		if (b != null) {
			return (b ? 1 : 0);
		} else {
			return 0;
		}
	}
	
	/**
	 * 指定した文字列をshort型に変換します。
	 * @param s 数字に変換する文字列です。
	 * @return 変換した数字を返します。文字列が数字に変換することができない場合、0を返します。
	 * @since 1.0.0
	 */
	public static short parseShort(String s) {
		return parseShort(s, (short)0);
	}
	
	/**
	 * 指定した文字列をshort型に変換します。
	 * @param s 数字に変換する文字列です。
	 * @param defaultValue 文字列が数字に変換することができない場合、使用するデフォルト値です。
	 * @return 変換した数字を返します。文字列が数字に変換することができない場合、defaultValueを返します。
	 * @since 1.0.0
	 */
	public static short parseShort(String s, short defaultValue) {
		short result = defaultValue;
		
		if (!StringUtil.isNullOrWhiteSpace(s)) {
			try {
				result = Short.parseShort(s);
			} catch (Exception e) {
			}
		}
		
		return result;
	}
	
	/**
	 * {@link Short} 型をshort型に変換します。
	 * @param n　変換する数字です。
	 * @return　変換した数字を返します。nがnullである場合、0を返します。
	 * @since 1.0.0
	 */
	public static short parseShort(Short n) {
		return parseShort(n, (short)0);
	}
	
	/**
	 * {@link Short} 型をshort型に変換します。
	 * @param n　変換する数字です。
	 * @param defaultValue　nがnullである場合、使用するデフォルト値です。
	 * @return　変換した数字を返します。nがnullである場合、defaultValueを返します。
	 * @since 1.0.0
	 */
	public static short parseShort(Short n, short defaultValue) {
		if (n != null) {
			return n;
		} else {
			return defaultValue;
		}
	}
}
