package jp.agentec.abook.abv.launcher.android;

import java.io.File;

import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.log.Logger;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.widget.Toast;

/**
 * 新しいAPKのダウンロードが完了したときの通知を受け取る
 * @author jang
 *
 */
public class OnAppDownloadReceiver extends BroadcastReceiver {

	@Override
	public void onReceive(Context context, Intent intent) {
		if (intent.getAction().equals(DownloadManager.ACTION_DOWNLOAD_COMPLETE)) {
			long id = intent.getLongExtra(DownloadManager.EXTRA_DOWNLOAD_ID, -1);
			Logger.d("Download Complete ID : " + id);

            if (id == -1) {
                // ダウンロードマネージャの通知領域をクリックした場合はメッセージ表示のみ
                Toast.makeText(context, intent.getAction(), Toast.LENGTH_LONG).show();
            } else {
                File file = new File(context.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS), ABVEnvironment.APK_FILE_NAME);
                if (file.exists()) {
                    Intent i = new Intent(Intent.ACTION_VIEW);
                    // Activity以外からActivityを呼び出すためのフラグを設定
                    i.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    i.setDataAndType(Uri.fromFile(file), "application/vnd.android.package-archive");
                    context.startActivity(i);
                } else {
                    Toast.makeText(context, "No Exist APK File: ", Toast.LENGTH_LONG).show();
                }
            }
		}
	}

}
