package jp.agentec.abook.abv.ui.common.activity;

import android.widget.Toast;

import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.exception.ABVException;
import jp.agentec.abook.abv.bl.common.log.LogLevel;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.cl.environment.DeviceInfo;
import jp.agentec.abook.abv.cl.push.FcmManager;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.util.ABVToastUtil;

/**
 * Login処理の共通ロジックを実装する
 * @author jang
 *
 */
public abstract class ABVLoginActivity extends ABVNoAuthenticatedActivity {
	private static final String TAG = "ABVLoginActivity";

	/**
	 * サーバ認証後、ローカルのデータの削除が必要であればアラートを表示する。<br>
	 * 必要なければユーザ情報を保存する。
	 */
	protected void fcmRegister() {
		String fcmToken = FcmManager.getFcmToken(this);
		try {
			if (fcmToken == null) {
				Logger.w(TAG, "[fcmRegister]: FCM Token is null.");
				runOnUiThread(new Runnable() {
					@Override
					public void run() {
						ABVToastUtil.showMakeText(ABVLoginActivity.this, R.string.fcm_not_supported, Toast.LENGTH_SHORT);
					}
				});
				// FCMトークンを取得できない場合、noneIdでセットしてログインする
				fcmToken = "noneId";
			}
			serverLoginAndCheckChangeUser(fcmToken);
		} finally {
			closeProgressPopup();
		}
	}
	
	/**
	 * MACアドレスを取得し、envにセットする。
	 * 
	 * @throws ABVException
	 */
	protected void loadWifiMacAddress() throws ABVException {
        // Android 6以上場合はMacAddressが取得できないためSkipする
        if (android.os.Build.VERSION.SDK_INT >= 23) {
            return;
        }
		boolean isDebugMode = LogLevel.level(getRInteger(R.integer.log_level)).level() <= LogLevel.debug.level();
		ABVEnvironment.getInstance().deviceId = DeviceInfo.getDeviceId(this, isDebugMode);
		ABVEnvironment.getInstance().encryptKey = DeviceInfo.getEncryptKey(this, isDebugMode);
	}
	
	protected abstract void serverLoginAndCheckChangeUser(String deviceToken);
}
