package jp.agentec.abook.abv.ui.common.view;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageButton;

/**
 * Created by tauch on 2016/06/03.
 */
public class ABVImageButton extends ImageButton {

	public ABVImageButton(Context context) {
		super(context);
	}

	public ABVImageButton(Context context, AttributeSet attrs) {
		super(context, attrs);
	}

	public ABVImageButton(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);
	}

	@Override
	public void setPressed(boolean pressed) {
		super.setPressed(pressed);

		Drawable background = getBackground();

		if (pressed) {
			setColorFilter(new PorterDuffColorFilter(0x55000000, PorterDuff.Mode.SRC_ATOP));

			if (background != null) {
				background.setColorFilter(new PorterDuffColorFilter(0x55000000, PorterDuff.Mode.SRC_ATOP));
			}
		} else {
			clearColorFilter();

			if (background != null) {
				background.clearColorFilter();
			}
		}
	}
}
