package jp.agentec.abook.abv.ui.common.view;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.launcher.android.R;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;

public class ABVListDialog extends Dialog {

	public TextView titleView;

	private View mRoot;
	private View mAddedView = null;
	private LinearLayout mListFooterLayout;
	private ListAdapter mAdapter = null;

	public ABVListDialog(Context context) {
		super(context);

		mRoot = ((Activity) context).getLayoutInflater().inflate(R.layout.list_dialog, null);

		setCanceledOnTouchOutside(true);
		requestWindowFeature(Window.FEATURE_NO_TITLE);

		titleView = (TextView) mRoot.findViewById(R.id.popup_title);
		mListFooterLayout = new LinearLayout(context);
		setContentView(mRoot);
	}

	public ABVListDialog(Activity activity, String title) {
		this(activity);
		setTitle(title);
	}

	public void setTitle(String title) {
		setTitle(title, 0);
	}
	
	public void setTitle(String title, int resourceId) {
		titleView.setText(title);
		if (resourceId != 0) {
			titleView.setCompoundDrawablesWithIntrinsicBounds(resourceId, 0, 0, 0);
		}
	}

	public void setListViewAdapter(ListAdapter adapter) {
		mAdapter = adapter;
		final ListView listView = getListView();
		listView.addFooterView(mListFooterLayout);
		listView.setAdapter(adapter);
		listView.setItemsCanFocus(true);
		// ListViewをLastItemまで移動させる
		listView.post(new Runnable() {
			@Override
			public void run() {
				listView.setSelection(0);
			}
		});
	}
	
	public ListAdapter getListViewAdapter() {
		return mAdapter;
	}

	public void setHeaderView(View headerView) {
		LinearLayout linearLayout = (LinearLayout) mRoot.findViewById(R.id.popup_header);
		linearLayout.addView(headerView);
		linearLayout.setVisibility(View.VISIBLE);
	}

	public void setFooterView(View footerView) {
		LinearLayout linearLayout = (LinearLayout) mRoot.findViewById(R.id.popup_footer);
		linearLayout.addView(footerView);
		linearLayout.setVisibility(View.VISIBLE);
	}

	public void setListEmptyText(String text) {
		TextView textView = (TextView) mRoot.findViewById(R.id.empty_list_item);
		textView.setText(text);
		getListView().setEmptyView(mRoot.findViewById(R.id.empty_layout));
		
	}

	public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
		getListView().setOnItemClickListener(listener);
	}
	
	public void setOnItemLongClickListener(AdapterView.OnItemLongClickListener listener) {
		getListView().setOnItemLongClickListener(listener);
	}

	public void setLeftItemOnClickListener(String itemName, View.OnClickListener l) {
//		Button itemButton = (Button) mRoot.findViewById(R.id.popup_title_left);
//		if (itemButton != null) {
//			itemButton.setVisibility(View.VISIBLE);
//			itemButton.setText(itemName);
//			itemButton.setOnClickListener(l);
//		} else {
			// 携帯の場合
			LinearLayout linearLayout = (LinearLayout) mRoot.findViewById(R.id.left_item);
			linearLayout.setOnClickListener(l);
			linearLayout.setVisibility(View.VISIBLE);
			TextView textView = (TextView) mRoot.findViewById(R.id.header_title);
			String suffixText = getContext().getResources().getString(R.string.to_back);
			textView.setText(String.format(suffixText, itemName));
//		}
	}
	public void setRightItemOnClickListener(int resId, View.OnClickListener l) {
		ImageButton itemButton = (ImageButton) mRoot.findViewById(R.id.popup_right_image);
		if (itemButton != null) {
			itemButton.setBackgroundResource(resId);
			itemButton.setVisibility(View.VISIBLE);
			itemButton.setOnClickListener(l);
		}
	}

	public void setRightItemOnClickListener(String itemName, View.OnClickListener l) {
		Button itemButton = (Button) mRoot.findViewById(R.id.popup_right_title);
		if (itemButton != null) {
			itemButton.setText(itemName);
			itemButton.setVisibility(View.VISIBLE);
			itemButton.setOnClickListener(l);
		}
	}

	public ListView getListView() {
		return (ListView) mRoot.findViewById(R.id.popup_list_menu);
	}
	
	public void addNewView(View v) {
		LinearLayout.LayoutParams l = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
		LinearLayout layout = (LinearLayout) mRoot.findViewById(R.id.empty_layout);
		if (layout.getVisibility() == View.VISIBLE) {
			Logger.d("empty_layout is visible addNewView:count=" + layout.getChildCount());
			if (layout.getChildCount() > 0) {
				Logger.d("empty_layout child " + layout.getChildAt(0));
			}
			// emptylayoutに追加
			layout.removeAllViews();
			layout.addView(v, l);
			((BaseAdapter)mAdapter).notifyDataSetChanged();
		} else {
			Logger.d("empty_layout is novisible addNewView:count=" + layout.getChildCount());
			if (mAddedView != null) {
				mListFooterLayout.removeView(mAddedView);
			}
			mListFooterLayout.addView(v, l);
			mAddedView = v;
			
			// ListViewをLastItemまで移動させる
			final ListView lv = getListView();
			lv.post(new Runnable() {
				@Override
				public void run() {
					lv.setSelection(lv.getAdapter().getCount() - 1);				
				}
			});
		}
		
	}

	@Override
	public void show() {
		DisplayMetrics metrics = getContext().getResources().getDisplayMetrics();
		int dialogWidth;

		if (metrics.widthPixels > metrics.heightPixels) {
			dialogWidth = (int) (metrics.heightPixels * 0.8);
		} else {
			dialogWidth = (int) (metrics.widthPixels * 0.8);
		}
		if (getWindow() != null) {
            WindowManager.LayoutParams lp = getWindow().getAttributes();
            lp.width = dialogWidth;
            lp.height = dialogWidth;
            getWindow().setAttributes(lp);

            Button left = (Button) findViewById(R.id.popup_title_left);
            if (left != null) {
                left.setMaxWidth(dialogWidth / 5 * 2);
            }

//		Button right = (Button) findViewById(R.id.popup_title_right);
//		right.setMaxWidth(dialogWidth / 5);

            titleView.setMaxWidth(dialogWidth / 5 * 3);
        }
		super.show();
	}
	
	public void showHalfSize() {
		DisplayMetrics metrics = getContext().getResources().getDisplayMetrics();
        if (getWindow() != null) {
            WindowManager.LayoutParams lp = getWindow().getAttributes();
            lp.width = metrics.widthPixels;
            lp.height = (int) (metrics.heightPixels * 0.5);
//		lp.gravity = Gravity.BOTTOM;
            getWindow().setAttributes(lp);

//		Button left = (Button) findViewById(R.id.popup_title_left);
//		if (left != null) left.setMaxWidth(dialogWidth / 5 * 2);

//		Button right = (Button) findViewById(R.id.popup_title_right);
//		right.setMaxWidth(dialogWidth / 5);
        }
            super.show();
	}
	
	public void reload() {
		dismiss();
		show();
		if (mAdapter != null) {
			((BaseAdapter)mAdapter).notifyDataSetChanged();
		}
	}

}
