package jp.agentec.abook.abv.ui.home.adapter;

import android.content.Context;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import java.util.List;

import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.home.adapter.common.BaseSectionAdapter;
import jp.agentec.abook.abv.ui.home.adapter.common.IndexPath;
import jp.agentec.abook.abv.ui.home.adapter.common.SectionHeaderData;

public class BleListAdapter extends BaseSectionAdapter<SectionHeaderData, BleListRowData> {
    private static final String TAG = "BleListAdapter";
    protected BleListAdapter.BleListAdapterListener listener;

    public interface BleListAdapterListener {
        // 登録されたデバイス情報削除(bluetooth情報を引数としてセット）
        void onDeleteConnectInfo(BleListRowData rowData);
    }

    public BleListAdapter(Context context, List<SectionHeaderData> sectionList,
                                    List<List<BleListRowData>> rowList, BleListAdapterListener listener) {
        super(context, sectionList, rowList);
        this.listener = listener;
    }


    @Override
    public View viewForHeaderInSection(View convertView, int section) {
        ListHeaderViewHolder holder = null;
        if (convertView == null) {
            convertView = inflater.inflate(R.layout.ble_section_list_header, null);
            holder = new ListHeaderViewHolder();
            holder.titleTxt = (TextView) convertView.findViewById(R.id.titleTxt);
            holder.subtitleTxt = (TextView) convertView.findViewById(R.id.subTitleTxt);
            convertView.setTag(holder);
        } else {
            holder = (ListHeaderViewHolder) convertView.getTag();
        }
        SectionHeaderData headerData = sectionList.get(section);
        holder.titleTxt.setText(headerData.title);
        holder.subtitleTxt.setText(headerData.subTitle);
        return convertView;
    }

    @Override
    public View cellForRowAtIndexPath(View convertView, IndexPath indexPath) {
        ListRowViewHolder holder = null;
        if (convertView == null) {
            convertView = inflater.inflate(R.layout.ble_section_list_row, null);
            holder = new ListRowViewHolder();
            // bluetoothのデバイス名
            holder.bl_title = (TextView) convertView.findViewById(R.id.bl_title);
            // 該当通信機器の名（中心温度計・放射温度計）
            holder.sub_title = (TextView) convertView.findViewById(R.id.sub_title);
            // 削除ボタン
            holder.bl_deleteBtn = (Button) convertView.findViewById(R.id.bl_deleteBtn);
            convertView.setTag(holder);
        } else {
            holder = (ListRowViewHolder) convertView.getTag();
        }
        final BleListRowData rowData = rowList.get(indexPath.section).get(indexPath.row);
        holder.bl_title.setText(rowData.title);

        if (rowData.isSaved) {
            // 既に保存されてる場合、削除ボタン表示・機器名は非表示
            holder.sub_title.setVisibility(View.GONE);
            holder.bl_deleteBtn.setVisibility(View.VISIBLE);
            holder.bl_deleteBtn.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    listener.onDeleteConnectInfo(rowData);
                }
            });
        } else {
            // スキャンされたbluetooth機器表示時に削除ボタンと接続ステータス非表示
            holder.bl_deleteBtn.setVisibility(View.GONE);
            holder.sub_title.setVisibility(View.VISIBLE);
            holder.sub_title.setText(rowData.subTitle);
        }
        return convertView;
    }

    static class ListHeaderViewHolder {
        TextView titleTxt;
        TextView subtitleTxt;
    }

    static class ListRowViewHolder {
        TextView bl_title;
        TextView sub_title;
        Button bl_deleteBtn;
    }

    public void setItem(List<SectionHeaderData> sectionList, List<List<BleListRowData>> rowList) {
        settingSectionRowData(sectionList, rowList);
        notifyDataSetChanged();
    }
}
