package jp.agentec.abook.abv.ui.viewer.view;

import android.content.Context;
import android.graphics.Color;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;

import jp.agentec.abook.abv.launcher.android.R;

/**
 * Created by seo-y on 2018/11/14.
 */

public class ActionOperationTaskIcon extends ImageView {
    public String taskKey;
    private boolean isAnimated = false;
    private Animation animation;

    public ActionOperationTaskIcon(final Context context) {
        super(context);

        setImageResource(R.drawable.ic_task_hotspot);
        setBackgroundColor(Color.TRANSPARENT);
        setAdjustViewBounds(true);
        setScaleType(ScaleType.FIT_START);
    }

    public void stopAnimation() {
        if (this.isAnimated) {
            this.clearAnimation();
            this.isAnimated = false;
        }
    }

    public void startBlinkAnimation() {
        if (animation == null) {
            animation = new AlphaAnimation(1, 0);
            animation.setDuration(1000);
            animation.setInterpolator(new LinearInterpolator());
            animation.setRepeatCount(Animation.INFINITE);
            animation.setRepeatMode(Animation.REVERSE);
        }

        this.startAnimation(animation);
        this.isAnimated = true;
    }
}
